/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.entities.system.difsso;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 04/09/2015
 */
public class SSOResponse {

    /**  */
    private String errorMessage;

    /**  */
    private String errorMessageTechDetails;

    /**  */
    private String redirectURL;

    /** */
    private boolean success;

    /**  */
    private String tokenID;

    /**
     * @param success
     * @param tokenID
     */
    public SSOResponse(boolean success, String tokenID)
    {
        this.success = success;
        this.tokenID = tokenID;
    }

    /**
     * @param success
     * @param tokenID
     * @param errorMessage
     */
    public SSOResponse(boolean success, String tokenID, String errorMessage)
    {
        this.errorMessage = errorMessage;
        this.success = success;
        this.tokenID = tokenID;
    }

    /**
     * Inspector for the 'errorMessage' attribute.
     * 
     * @return the errorMessage value
     */
    public String getErrorMessage()
    {
        return errorMessage;
    }

    /**
     * Inspector for the 'errorMessageTechDetails' attribute.
     * 
     * @return the errorMessageTechDetails value
     */
    public String getErrorMessageTechDetails()
    {
        return errorMessageTechDetails;
    }

    /**
     * Inspector for the 'redirectURL' attribute.
     * 
     * @return the redirectURL value
     */
    public String getRedirectURL()
    {
        return redirectURL;
    }

    /**
     * Inspector for the 'tokenID' attribute.
     * 
     * @return the tokenID value
     */
    public String getTokenID()
    {
        return tokenID;
    }

    /**
     * Inspector for the 'success' attribute.
     * 
     * @return the success value
     */
    public boolean isSuccess()
    {
        return success;
    }

    /**
     * Modifier for the 'errorMessage' attribute.
     * 
     * @param errorMessage
     *            the new errorMessage value to set
     */
    public void setErrorMessage(String errorMessage)
    {
        this.errorMessage = errorMessage;
    }

    /**
     * Modifier for the 'errorMessageTechDetails' attribute.
     * 
     * @param errorMessageTechDetails
     *            the new errorMessageTechDetails value to set
     * @return the updated object
     */
    public SSOResponse setErrorMessageTechDetails(String errorMessageTechDetails)
    {
        this.errorMessageTechDetails = errorMessageTechDetails;

        return this;
    }

    /**
     * Modifier for the 'redirectURL' attribute.
     * 
     * @param redirectURL
     *            the new redirectURL value to set
     * @return the updated object
     */
    public SSOResponse setRedirectURL(String redirectURL)
    {
        this.redirectURL = redirectURL;

        return this;
    }

    /**
     * Modifier for the 'success' attribute.
     * 
     * @param success
     *            the new success value to set
     */
    public void setSuccess(boolean success)
    {
        this.success = success;
    }

    /**
     * Modifier for the 'tokenID' attribute.
     * 
     * @param tokenID
     *            the new tokenID value to set
     */
    public void setTokenID(String tokenID)
    {
        this.tokenID = tokenID;
    }
}
