/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.entities.system.difsso;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * The Class SSOSecurityConfiguration.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 01/09/2015
 */
@ConfigID("dif2")
@ConfigSectionID("Security/SSO")
public class SSOSecurityConfiguration {

    /** The singleton instance property. */
    private static SSOSecurityConfiguration instance;

    /**
     * Returns the active configuration object instance.
     * 
     * @return the configuration instance
     * @throws Exception
     *             the exception
     */
    @ConfigIgnore
    static public SSOSecurityConfiguration getInstance() throws Exception
    {
        if (instance == null)
        {
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(SSOSecurityConfiguration.class);
            }
            catch (Exception e)
            {
                e.printStackTrace();
                instance = null;
            }
        }

        return instance;
    }

    /** if T will allow SSO requests */
    private Boolean active;

    /** the list of server IPs to allow requests from */
    private String serverIPWhiteList;

    /**  */
    private Long tokenRetentionPeriod;

    /**
     * Inspector for the 'active' attribute.
     * 
     * @return the active value
     */
    @ConfigDefault("false")
    public Boolean getActive()
    {
        return active;
    }

    /**
     * Inspector for the 'serverIPWhiteList' attribute.
     * 
     * @return the serverIPWhiteList value
     */
    public String getServerIPWhiteList()
    {
        return serverIPWhiteList;
    }

    /**
     * Inspector for the 'tokenRetentionPeriod' attribute.
     * 
     * @return the tokenRetentionPeriod value
     */
    @ConfigDefault("10")
    public Long getTokenRetentionPeriod()
    {
        return tokenRetentionPeriod;
    }

    /**
     * Modifier for the 'active' attribute.
     * 
     * @param active
     *            the new active value to set
     */
    public void setActive(Boolean active)
    {
        this.active = active;
    }

    /**
     * Modifier for the 'serverIPWhiteList' attribute.
     * 
     * @param serverIPWhiteList
     *            the new serverIPWhiteList value to set
     */
    public void setServerIPWhiteList(String serverIPWhiteList)
    {
        this.serverIPWhiteList = serverIPWhiteList;
    }

    /**
     * Modifier for the 'tokenRetentionPeriod' attribute.
     * 
     * @param tokenRetentionPeriod
     *            the new tokenRetentionPeriod value to set
     */
    public void setTokenRetentionPeriod(Long tokenRetentionPeriod)
    {
        this.tokenRetentionPeriod = tokenRetentionPeriod;
    }
}
