/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.presentation.entities.system.difsso;

import java.util.Date;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 02/09/2015
 */
public class SSOToken {

    /** the token ID */
    private String id;

    /** the stage */
    private String stageID;

    /** token generation date to validate expiration */
    private Date tokenGenerationDate;

    /** the user to auto authenticate (SSO) */
    private String userID;

    /**
     * Inspector for the 'id' attribute.
     * 
     * @return the id value
     */
    public String getId()
    {
        return id;
    }

    /**
     * Inspector for the 'stageID' attribute.
     * 
     * @return the stageID value
     */
    public String getStageID()
    {
        return stageID;
    }

    /**
     * Inspector for the 'tokenGenerationDate' attribute.
     * 
     * @return the tokenGenerationDate value
     */
    public Date getTokenGenerationDate()
    {
        return tokenGenerationDate;
    }

    /**
     * Inspector for the 'userID' attribute.
     * 
     * @return the userID value
     */
    public String getUserID()
    {
        return userID;
    }

    /**
     * @return T if the token has expired
     * @throws Exception
     */
    public boolean isExpired() throws Exception
    {
        return ((new Date().getTime()) - this.getTokenGenerationDate()
                .getTime() > (SSOSecurityConfiguration.getInstance().getTokenRetentionPeriod() * 1000));
    }

    /**
     * Modifier for the 'id' attribute.
     * 
     * @param id
     *            the new id value to set
     */
    public void setId(String id)
    {
        this.id = id;
    }

    /**
     * Modifier for the 'stageID' attribute.
     * 
     * @param stageID
     *            the new stageID value to set
     */
    public void setStageID(String stageID)
    {
        this.stageID = stageID;
    }

    /**
     * Modifier for the 'tokenGenerationDate' attribute.
     * 
     * @param tokenGenerationDate
     *            the new tokenGenerationDate value to set
     */
    public void setTokenGenerationDate(Date tokenGenerationDate)
    {
        this.tokenGenerationDate = tokenGenerationDate;
    }

    /**
     * Modifier for the 'userID' attribute.
     * 
     * @param userID
     *            the new userID value to set
     */
    public void setUserID(String userID)
    {
        this.userID = userID;
    }
}
