/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.presentation.ioc;

import pt.digitalis.dif.presentation.assets.IAssetProvider;
import pt.digitalis.dif.sanitycheck.CheckConfigurations;
import pt.digitalis.dif.sanitycheck.CheckDigitalSignatureConfigurations;
import pt.digitalis.dif.sanitycheck.ISanityCheckTestSuite;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Test Module for Unit testing
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Dec 20, 2007
 */
public class DIFPresentationModule implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        binder.install(new ControllerModule());
        binder.install(new DIFViewRenderers());

        binder.bind(IAssetProvider.class, PresentationAssets.class).withId("difpresentation");

        // Add Guice ServletModule for HTTPServlet injections
        // Is comment out until it is required.
        // binder.installSpecific(new ServletModule());

        // Sanity Check
        binder.bind(ISanityCheckTestSuite.class, CheckConfigurations.class)
                .withId("difpresentationCheckConfigurations");
        binder.bind(ISanityCheckTestSuite.class, CheckDigitalSignatureConfigurations.class)
                .withId("difpresentationCheckDigitalSignatureConfigurations");
    }
}
