/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.presentation.ioc;

import pt.digitalis.dif.presentation.renderers.impl.ViewRendererDocumentImpl;
import pt.digitalis.dif.presentation.renderers.impl.ViewRendererJSONImpl;
import pt.digitalis.dif.presentation.renderers.impl.ViewRendererJSPImpl;
import pt.digitalis.dif.presentation.renderers.interfaces.IViewRenderer;
import pt.digitalis.dif.presentation.renderers.interfaces.IViewServletRenderer;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Module that declares the DIF bundled view renderers
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 */
public class DIFViewRenderers implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        binder.bind(IViewRenderer.class, ViewRendererJSPImpl.class).withId("jsp");
        binder.bind(IViewServletRenderer.class, ViewRendererJSPImpl.class).withId("jsp");

        binder.bind(IViewRenderer.class, ViewRendererJSONImpl.class).withId("ajax");
        binder.bind(IViewServletRenderer.class, ViewRendererJSONImpl.class).withId("ajax");

        binder.bind(IViewRenderer.class, ViewRendererDocumentImpl.class).withId("docs");
        binder.bind(IViewServletRenderer.class, ViewRendererDocumentImpl.class).withId("docs");
    }
}
