/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.presentation.renderers.impl;

import java.io.IOException;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.newrelic.api.agent.Trace;

import pt.digitalis.dif.controller.http.HTTPConstants;
import pt.digitalis.dif.controller.http.WebBrowserInfo;
import pt.digitalis.dif.controller.interfaces.IDIFResponse;
import pt.digitalis.dif.presentation.documents.DocumentResponseRepositoryImpl;
import pt.digitalis.dif.presentation.documents.IDocumentResponse;
import pt.digitalis.dif.presentation.renderers.CacheInfoConstants;
import pt.digitalis.dif.presentation.renderers.annotations.AllowedChannels;
import pt.digitalis.dif.presentation.renderers.interfaces.IViewServletRenderer;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryException;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 */
@AllowedChannels("http")
public class ViewRendererDocumentImpl implements IViewServletRenderer {

    /**
     * @see pt.digitalis.dif.presentation.renderers.interfaces.IViewRenderer#renderView(pt.digitalis.dif.controller.interfaces.IDIFResponse)
     */
    public boolean renderView(IDIFResponse response)
    {
        // Nothing to do since the render process is a simple delegate of the servlet/jsp to run
        return false;
    }

    /**
     * @see pt.digitalis.dif.presentation.renderers.interfaces.IViewServletRenderer#renderView(pt.digitalis.dif.controller.interfaces.IDIFResponse,
     *      javax.servlet.ServletContext, javax.servlet.ServletRequest, javax.servlet.ServletResponse)
     */
    @Trace(metricName = "DIF:DocumentViewRenderer", dispatcher = true)
    public boolean renderView(IDIFResponse response, ServletContext servletContext, ServletRequest servletRequest,
            ServletResponse servletResponse) throws ServletException, IOException
    {

        HttpServletResponse httpResponse = (HttpServletResponse) servletResponse;

        String documentID = servletRequest.getParameter(HTTPConstants.DOCID_PARAMETER);

        String docIsAttachmentValue = servletRequest.getParameter(HTTPConstants.DOC_IS_ATTACHMENT_PARAMETER);
        Boolean docIsAttachment = true;
        if (docIsAttachmentValue != null)
        {
            docIsAttachment = new Boolean(docIsAttachmentValue);
        }

        IDocumentResponse docResponse = null;

        // A document by ID was requested...
        if (documentID != null)
            try
            {
                // IDocumentRepositoryManager docRepositoryManager = DIFIoCRegistry.getRegistry().getImplementation(
                // IDocumentRepositoryManager.class);
                // ISessionManager sessionManager =
                // DIFIoCRegistry.getRegistry().getImplementation(ISessionManager.class);
                // IDIFSession session;
                //
                // if (response != null)
                // session = response.getRequest().getSession();
                // else
                // session = sessionManager.createSession(HttpUtils
                // .buildSessionId(((HttpServletRequest) servletRequest).getSession()));

                // // If the document is authorized serve it
                // if (docRepositoryManager.isDocumentAuthorizedInCurrentSession(session, Long.parseLong(documentID)))
                docResponse = new DocumentResponseRepositoryImpl(new Long(documentID));
                // // If not...
                // else
                // {
                // // Raise the exception...
                // UnauthorizedDocumentAccess e = new UnauthorizedDocumentAccess(session,
                // NumericUtils.toLong(documentID));
                //
                // // Report the unauthorized access to log
                // DIFLogger.getLogger().warn(e.getRenderedExceptionContext());
                //
                // throw e;
                // }
            }
            catch (NumberFormatException e)
            {
                throw new ServletException(e);
            }
            catch (DocumentRepositoryException e)
            {
                throw new ServletException(e);
            }
        else
        {
            // No document, gather results form the response generated by the stage execution...
            // Get the stage execution results, where the DOC result has been stored...
            Map<String, Object> results = response.getStageResults();

            if (results.containsKey("DIF-DOC"))
                docResponse = (IDocumentResponse) results.get("DIF-DOC");
        }

        if (docResponse != null)
        {
            httpResponse.setContentType(docResponse.getDocumentType() + "; charset=" + docResponse.getCharSet());

            /* Workaround for IE problem http://support.microsoft.com/default.aspx?scid=kb;en-us;316431 */
            WebBrowserInfo browserInfo = new WebBrowserInfo((HttpServletRequest) servletRequest);
            if (!(CacheInfoConstants.NO_CACHE.equals(docResponse.getCacheInfo()) && browserInfo.isIE()))
                httpResponse.setHeader("Cache-Control", docResponse.getCacheInfo());

            httpResponse.setCharacterEncoding(docResponse.getCharSet());

            for (Entry<String, String> entry: docResponse.getHeaders().entrySet())
                httpResponse.setHeader(entry.getKey(), entry.getValue());

            String contentDisposition = "filename=\"" + docResponse.getFileName() + "\"";
            if (docIsAttachment)
            {
                contentDisposition = "attachment; " + contentDisposition;
            }
            httpResponse.setHeader("Content-Disposition", contentDisposition);

            docResponse.writeData(httpResponse.getOutputStream());
        }

        return true;
    }
}
