package pt.digitalis.dif.sanitycheck;

import pt.digitalis.dif.controller.http.HTTPControllerConfiguration;
import pt.digitalis.dif.sanitycheck.annotations.SanityCheckTest;

/**
 * The Class CheckConfigurations.
 * 
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Aug 10, 2011
 */
public class CheckConfigurations extends AbstractSanityCheckTestSuite {

    /**
     * Test1 configurations.
     * 
     * @return the test result
     */
    @SanityCheckTest
    public TestResult test1MainConfigurations()
    {
        HTTPControllerConfiguration httpControllerConfiguration = HTTPControllerConfiguration.getInstance();
        String errorMessage = "";
        TestResult testResult;
        if (httpControllerConfiguration.getServerBaseURL() == null
                || "".equals(httpControllerConfiguration.getServerBaseURL().trim()))
        {
            errorMessage = "The ServerBaseURL configuration parameter is empty. Please fill this configuration in [CONFS]/dif2/Controller/http.";
            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(errorMessage);
        }
        else
        {
            testResult = new TestResult(ExecutionResult.PASSED);
        }

        return testResult;
    }

}