package pt.digitalis.dif.sanitycheck;

import java.io.ByteArrayOutputStream;

import pt.digitalis.dif.sanitycheck.annotations.SanityCheckTest;
import pt.digitalis.dif.utils.pdf.DigitalCertificateConfiguration;
import pt.digitalis.dif.utils.pdf.PDFUtils;

/**
 * The Class CheckConfigurations.
 * 
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Feb 7, 2012
 */
public class CheckDigitalSignatureConfigurations extends AbstractSanityCheckTestSuite {

    /**
     * Test pdf signature.
     * 
     * @return the test result
     */
    @SanityCheckTest
    public TestResult testPDFSignature()
    {
        TestResult testResult = null;
        try
        {
            DigitalCertificateConfiguration conf = DigitalCertificateConfiguration.getInstance();
            if (conf.getPath() != null && !"".equals(conf.getPath()))
            {

                ByteArrayOutputStream outStream = PDFUtils.signPDF(PDFUtils.createDummyPDF().toByteArray(),
                        conf.getShowSignature(), conf.getReason(), conf.getLocation(), conf.getContact(),
                        conf.getLowerLeftX(), conf.getLowerLeftY(), conf.getUpperRightX(), conf.getUpperRightY());
                if (PDFUtils.validateSignature(outStream.toByteArray()))
                {
                    testResult = new TestResult(ExecutionResult.PASSED);
                }
                else
                {
                    testResult = new TestResult(ExecutionResult.FAILED);
                }
            }
            else
            {
                testResult = new TestResult(ExecutionResult.WARNING);
            }
        }
        catch (Exception e)
        {
            testResult = new TestResult(ExecutionResult.FAILED);
            testResult.setErrorMessage(e.getMessage());
        }

        return testResult;
    }

}