/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.startup;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import pt.digitalis.utils.common.BeanInspector;
import pt.digitalis.utils.config.AbstractConfigurationsImpl;

/**
 * Triggers DIF startup for DIF WebApplications on deploy-time (App. Server startup)
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/03/17
 */
public class DIFWebAppStartup implements ServletContextListener {

    /**
     * @see javax.servlet.ServletContextListener#contextDestroyed(javax.servlet.ServletContextEvent)
     */
    public void contextDestroyed(ServletContextEvent sce)
    {
        // Do nothing... No cleanup required.
    }

    /**
     * @see javax.servlet.ServletContextListener#contextInitialized(javax.servlet.ServletContextEvent)
     */
    public void contextInitialized(ServletContextEvent sce)
    {
        ServletContext context = sce.getServletContext();

        // Capture the WAR file
        String webApplicationWARName;
        webApplicationWARName = BeanInspector.getPrivateAttributeValueAsString(context, "context.context.encodedPath");

        if (webApplicationWARName == null)
            webApplicationWARName = "";
        else
            webApplicationWARName = webApplicationWARName.substring(1);

        // Set the context prefix for configurations
        AbstractConfigurationsImpl.setGeneralPrefix(webApplicationWARName);

        // DIF full initialization
        DIFInitializer.initialize(true, true);
    }
}
