/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils;

import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * Class para persistir as configuraes da DIF. Dever ser usada a Configuration_utils para a sua persistencia.
 * 
 * @author Pedro Viegas
 * @version 1.0
 * @created 10-Feb-2009 14:05:52
 */
@ConfigID("dif2")
@ConfigSectionID("Registration")
public class RegistrationConfiguration {

    /** the singleton instance */
    static private RegistrationConfiguration instance;

    /**
     * @return the registration configuration instance
     */
    @ConfigIgnore
    static public RegistrationConfiguration getInstance()
    {
        if (instance == null)
            instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                    .readConfiguration(RegistrationConfiguration.class);

        return instance;
    }

    /** Enables the administrator to create users automatically */
    private boolean allowAutoCreateUser;

    /** Enables the automatic creation of the user name */
    private boolean autoGenerateUserName;

    /** Enables the automatic creation of the user password */
    private boolean autoGenerateUserPass;

    /** the default profile ID to add the user */
    private String defaultProfileID = null;

    /** The disclaimer template for css */
    private String disclaimer;

    /** Every couple of hours the monitor checks for expired requests */
    private int expirationMonitorInterval;

    /** Enables the captcha validation field */
    private boolean hasCaptchaValidation;

    /** The minimal number of consecutive charaters contained in username that must not be in password */
    private Integer minimalNumberConsecutiveCharatersFromUsername;

    /** The password policy pattern */
    private String passwordPattern;

    /** Password pattern warning */
    private String passwordPatternWarning;

    /** The mail list (comma separated) to send notifications */
    private String pendingRequestsMailingList;

    /** The registration email template */
    private String registrationMailTemplate;

    /** The number of day unconfirmed registrations are considered expired. */
    private int requestExpirationDays;

    /** Configuration value for template */
    @Parameter
    protected String templateClientRegistrationPolicy;

    /** User name acceptance regex pattern */
    private String usernamePattern;

    /**
     *
     */
    public RegistrationConfiguration()
    {

    }

    /**
     * @see java.lang.Object#finalize()
     */
    @Override
    public void finalize() throws Throwable
    {

    }

    /**
     * Inspector for the 'defaultProfileID' attribute.
     * 
     * @return the defaultProfileID value
     */
    public String getDefaultProfileID()
    {
        return defaultProfileID;
    }

    /**
     * Inspector for the 'disclaimer' attribute.
     * 
     * @return the disclaimer value
     */
    @ConfigDefault("templates/disclaimer.html")
    public String getDisclaimer()
    {
        return disclaimer;
    }

    /**
     * Inspector for the 'expirationMonitorInterval' attribute.
     * 
     * @return the expirationMonitorInterval value
     */
    @ConfigDefault("720")
    public int getExpirationMonitorInterval()
    {
        return expirationMonitorInterval;
    }

    /**
     * Inspector for the 'minimalNumberConsecutiveCharatersFromUsername' attribute.
     * 
     * @return the minimalNumberConsecutiveCharatersFromUsername value
     */
    @ConfigDefault("2")
    public Integer getMinimalNumberConsecutiveCharatersFromUsername()
    {
        return minimalNumberConsecutiveCharatersFromUsername;
    }

    /**
     * Inspector for the 'passwordPattern' attribute.
     * 
     * @return the passwordPattern value
     */
    @ConfigDefault("(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%^+=])(?=\\S+$).{6,16}")
    public String getPasswordPattern()
    {
        return passwordPattern;
    }

    /**
     * Inspector for the 'passwordPatternWarning' attribute.
     * 
     * @return the passwordPatternWarning value
     */
    @ConfigDefault("")
    public String getPasswordPatternWarning()
    {
        return passwordPatternWarning;
    }

    /**
     * Inspector for the 'pendingRequestsMailingList' attribute.
     * 
     * @return the pendingRequestsMailingList value
     */
    public String getPendingRequestsMailingList()
    {
        return pendingRequestsMailingList;
    }

    /**
     * Inspector for the 'registrationMailTemplate' attribute.
     * 
     * @return the registrationMailTemplate value
     */
    @ConfigDefault("templates/register.html")
    public String getRegistrationMailTemplate()
    {
        return registrationMailTemplate;
    }

    /**
     * Inspector for the 'requestExpirationDays' attribute.
     * 
     * @return the requestExpirationDays value
     */
    @ConfigDefault("5")
    public int getRequestExpirationDays()
    {
        return requestExpirationDays;
    }

    /**
     * Inspector for the 'templateClientRegistrationPolicy' attribute.
     * 
     * @return the templateClientRegistrationPolicy value
     */
    @ConfigDefault("")
    public String getTemplateClientRegistrationPolicy()
    {
        return templateClientRegistrationPolicy;
    }

    /**
     * Inspector for the 'usernamePattern' attribute.
     * 
     * @return the usernamePattern value
     */
    @ConfigDefault("^[a-zA-Z0-9_-]{3,15}$")
    public String getUsernamePattern()
    {
        return usernamePattern;
    }

    /**
     * Inspector for the 'allowAutoCreateUser' attribute.
     * 
     * @return the allowAutoCreateUser value
     */
    @ConfigDefault("false")
    public boolean isAllowAutoCreateUser()
    {
        return allowAutoCreateUser;
    }

    /**
     * Inspector for the 'autoGenerateUserName' attribute.
     * 
     * @return autoGenerateUserName
     */
    @ConfigDefault("false")
    public boolean isAutoGenerateUserName()
    {
        return autoGenerateUserName;
    }

    /**
     * Inspector for the 'autoGenerateUserPass' attribute.
     * 
     * @return autoGenerateUserPass
     */
    @ConfigDefault("false")
    public boolean isAutoGenerateUserPass()
    {
        return autoGenerateUserPass;
    }

    /**
     * Inspector for the 'hasCaptchaValidation' attribute.
     * 
     * @return the hasCaptchaValidation value
     */
    @ConfigDefault("false")
    public boolean isHasCaptchaValidation()
    {
        return hasCaptchaValidation;
    }

    /**
     * Modifier for the 'allowAutoCreateUser' attribute.
     * 
     * @param allowAutoCreateUser
     *            the new allowAutoCreateUser value to set
     */
    public void setAllowAutoCreateUser(boolean allowAutoCreateUser)
    {
        this.allowAutoCreateUser = allowAutoCreateUser;
    }

    /**
     * Modifier for the 'autoGenerateUserName' attribute.
     * 
     * @param autoGenerateUserName
     *            the new autoGenerateUserName value to set
     */
    public void setAutoGenerateUserName(boolean autoGenerateUserName)
    {
        this.autoGenerateUserName = autoGenerateUserName;
    }

    /**
     * Modifier for the 'autoGenerateUserPass' attribute.
     * 
     * @param autoGenerateUserPass
     *            the new autoGenerateUserPass value to set
     */
    public void setAutoGenerateUserPass(boolean autoGenerateUserPass)
    {
        this.autoGenerateUserPass = autoGenerateUserPass;
    }

    /**
     * Modifier for the 'defaultProfileID' attribute.
     * 
     * @param defaultProfileID
     *            the new defaultProfileID value to set
     */
    public void setDefaultProfileID(String defaultProfileID)
    {
        this.defaultProfileID = defaultProfileID;
    }

    /**
     * Modifier for the 'disclaimer' attribute.
     * 
     * @param disclaimer
     *            the new disclaimer value to set
     */
    public void setDisclaimer(String disclaimer)
    {
        this.disclaimer = disclaimer;
    }

    /**
     * Modifier for the 'expirationMonitorInterval' attribute.
     * 
     * @param expirationMonitorInterval
     *            the new expirationMonitorInterval value to set
     */

    public void setExpirationMonitorInterval(int expirationMonitorInterval)
    {
        this.expirationMonitorInterval = expirationMonitorInterval;
    }

    /**
     * Modifier for the 'hasCaptchaValidation' attribute.
     * 
     * @param hasCaptchaValidation
     *            the new hasCaptchaValidation value to set
     */
    public void setHasCaptchaValidation(boolean hasCaptchaValidation)
    {
        this.hasCaptchaValidation = hasCaptchaValidation;
    }

    /**
     * Modifier for the 'minimalNumberConsecutiveCharatersFromUsername' attribute.
     * 
     * @param minimalNumberConsecutiveCharatersFromUsername
     *            the new minimalNumberConsecutiveCharatersFromUsername value to set
     */
    public void setMinimalNumberConsecutiveCharatersFromUsername(Integer minimalNumberConsecutiveCharatersFromUsername)
    {
        this.minimalNumberConsecutiveCharatersFromUsername = minimalNumberConsecutiveCharatersFromUsername;
    }

    /**
     * Modifier for the 'passwordPattern' attribute.
     * 
     * @param passwordPattern
     *            the new passwordPattern value to set
     */
    public void setPasswordPattern(String passwordPattern)
    {
        this.passwordPattern = passwordPattern;
    }

    /**
     * Modifier for the 'passwordPatternWarning' attribute.
     * 
     * @param passwordPatternWarning
     *            the new passwordPatternWarning value to set
     */
    public void setPasswordPatternWarning(String passwordPatternWarning)
    {
        this.passwordPatternWarning = passwordPatternWarning;
    }

    /**
     * Modifier for the 'pendingRequestsMailingList' attribute.
     * 
     * @param pendingRequestsMailingList
     *            the new pendingRequestsMailingList value to set
     */
    public void setPendingRequestsMailingList(String pendingRequestsMailingList)
    {
        this.pendingRequestsMailingList = pendingRequestsMailingList;
    }

    /**
     * Modifier for the 'registrationMailTemplate' attribute.
     * 
     * @param registrationMailTemplate
     *            the new registrationMailTemplate value to set
     */
    public void setRegistrationMailTemplate(String registrationMailTemplate)
    {
        this.registrationMailTemplate = registrationMailTemplate;
    }

    /**
     * Modifier for the 'requestExpirationDays' attribute.
     * 
     * @param requestExpirationDays
     *            the new requestExpirationDays value to set
     */
    public void setRequestExpirationDays(int requestExpirationDays)
    {
        this.requestExpirationDays = requestExpirationDays;
    }

    /**
     * Modifier for the 'templateClientRegistrationPolicy' attribute.
     * 
     * @param templateClientRegistrationPolicy
     *            the new templateClientRegistrationPolicy value to set
     */
    public void setTemplateClientRegistrationPolicy(String templateClientRegistrationPolicy)
    {
        this.templateClientRegistrationPolicy = templateClientRegistrationPolicy;
    }

    /**
     * Modifier for the 'usernamePattern' attribute.
     * 
     * @param usernamePattern
     *            the new usernamePattern value to set
     */
    public void setUsernamePattern(String usernamePattern)
    {
        this.usernamePattern = usernamePattern;
    }
}