package pt.digitalis.dif.rules;

import pt.digitalis.dif.dem.interfaces.IDIFAPI;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Apr 15, 2014
 */
public class DIFRulesAPI implements IDIFAPI {

    /**
     * @see pt.digitalis.dif.dem.interfaces.IDIFAPI#initialize()
     */
    public void initialize() throws InternalFrameworkException
    {
        try
        {
            IRulesManager rulesManager = DIFIoCRegistry.getRegistry().getImplementation(IRulesManager.class);
            if (rulesManager != null)
            {
                rulesManager.initialize();
            }

            IFlowManager flowManager = DIFIoCRegistry.getRegistry().getImplementation(IFlowManager.class);
            if (flowManager != null)
            {
                flowManager.initialize();
            }
        }
        catch (Exception e)
        {
            throw new InternalFrameworkException(e, null);
        }
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IDIFAPI#order()
     */
    public Integer order()
    {
        return 1;
    }

}
