/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules;

import java.util.Map;

import pt.digitalis.dif.rules.exceptions.rules.RuleException;
import pt.digitalis.dif.rules.objects.rules.AbstractRuleGroup;
import pt.digitalis.dif.rules.objects.rules.RuleResult;

/**
 * Declares the private management functionalities for the Rules Manager
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/22
 */
public interface IPrivateRulesManager extends IRulesManager {

    /**
     * Runs a Rule of type evaluation
     * 
     * @param ruleGroupInstance
     *            the parent rule group instance
     * @param uniqueRuleID
     *            the rule to execute, identified by it's unique name, including the rule group name. (i.e.
     *            "ruleGroupName.ruleName")
     * @param parameters
     *            parameters to pass to the rule
     * @return the rule evaluation result
     * @throws RuleException
     * @throws Throwable
     *             if any of the declared rule method exception is thrown
     */
    public boolean evaluateRule(AbstractRuleGroup ruleGroupInstance, String uniqueRuleID, Map<String, Object> parameters)
            throws RuleException, Throwable;

    /**
     * Runs a Rule and wraps the result in a {@link RuleResult} object. If any exception occurs in the rule execution it
     * will be saved and set in the exception attribute of the {@link RuleResult} object.
     * 
     * @param ruleGroupInstance
     *            the parent rule group instance
     * @param uniqueRuleID
     *            the rule to execute, identified by it's unique name, including the rule group name. (i.e.
     *            "ruleGroupName.ruleName")
     * @param parameters
     *            parameters to pass to the rule
     * @return the rule evaluation result
     * @throws RuleException
     */
    public RuleResult<?> executeRule(AbstractRuleGroup ruleGroupInstance, String uniqueRuleID,
            Map<String, Object> parameters) throws RuleException;
}
