/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.rules.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.AnnotationTags;

/**
 * Defines a Rule that executes a given business operation/process.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/21
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface RuleExecution {

    /**
     * The full rule id (group.ruleID) that will be tested prior to the rule execution. the action will only be
     * triggered in case of validation success of this rule.
     */
    String conditionRule() default AnnotationTags.NONE;

    /**
     * The description of the rule. Must contain a simple but complete textual description of what is validates and/or
     * executes
     */
    String description();

    /** The name of the rule id. unique inside the current group. */
    String name() default AnnotationTags.GENERATE_ID;
}
