/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.exceptions;

import pt.digitalis.dif.rules.IRulesManager;
import pt.digitalis.dif.rules.objects.AbstractDescriptor;

/**
 * An exception thrown by the {@link IRulesManager} in response to a non-managed ruleGroup initialization exception
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/06/30
 */
public class InitializationException extends Exception {

    /**  */
    private static final long serialVersionUID = 1L;

    /** the entity that has failed */
    private AbstractDescriptor descriptor;

    /**
     * @param descriptor
     * @param reason
     */
    public InitializationException(AbstractDescriptor descriptor, String reason)
    {
        super(reason);
        this.descriptor = descriptor;
    }

    /**
     * @param descriptor
     * @param reason
     * @param exception
     */
    public InitializationException(AbstractDescriptor descriptor, String reason, Throwable exception)
    {
        super(reason, exception);
        this.descriptor = descriptor;
    }

    /**
     * @param descriptor
     * @param exception
     */
    public InitializationException(AbstractDescriptor descriptor, Throwable exception)
    {
        super(exception);
        this.descriptor = descriptor;
    }

    /**
     * Inspector for the 'descriptor' attribute.
     * 
     * @return the descriptor
     */
    public AbstractDescriptor getDescriptor()
    {
        return descriptor;
    }

}
