/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.exceptions.rules;

import pt.digitalis.dif.rules.IRulesManager;
import pt.digitalis.dif.rules.objects.rules.RuleDescriptor;

/**
 * An exception thrown by the {@link IRulesManager} in response to a non-managed rule inner exception
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/06/30
 */
public class RuleException extends Exception {

    /**  */
    private static final long serialVersionUID = 1L;

    /** the Rule that has failed */
    private RuleDescriptor rule;

    /**
     * @param rule
     * @param reason
     */
    public RuleException(RuleDescriptor rule, String reason)
    {
        super(reason);
        this.rule = rule;
    }

    /**
     * @param rule
     * @param reason
     * @param exception
     */
    public RuleException(RuleDescriptor rule, String reason, Throwable exception)
    {
        super(reason, exception);
        this.rule = rule;
    }

    /**
     * @param rule
     * @param exception
     */
    public RuleException(RuleDescriptor rule, Throwable exception)
    {
        super(exception);
        this.rule = rule;
    }

    /**
     * Inspector for the 'rule' attribute.
     * 
     * @return the rule value
     */
    public RuleDescriptor getRule()
    {
        return rule;
    }

}
