/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.objects;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.rules.IRulesManager;
import pt.digitalis.dif.rules.objects.rules.RuleDescriptor;

/**
 * Base class for flow/rule descriptors based on Methods
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/29
 */
public abstract class AbstractMethodDescriptor extends AbstractDescriptor {

    /**
     * The full action id (group.ruleName) that will be tested prior to the action execution. The method will only be
     * triggered in case of validation success of this rule.
     */
    private String conditionRuleName;

    /**
     * The class method that declares this rule (will normally be the same as the methodToImplementation, but in
     * overrided implementations will be the original declaring method that contains the item details.
     */
    private Method declaringMethod;

    /** Indicates if the method if a boolean inspector or otherwise */
    boolean isBooleanResult;

    /** The RuleGroup class method that implements this rule */
    private Method methodToImplementation;

    /** Rule parameters on ivocation */
    private List<String> parameters = new ArrayList<String>();

    /**
     * Returns the condition rule descriptor
     * 
     * @return the conditionRule
     */
    public RuleDescriptor getConditionRule()
    {
        return DIFIoCRegistry.getRegistry().getImplementation(IRulesManager.class).getRule(this.getConditionRuleName());
    }

    /**
     * Inspector for the 'conditionRuleName' attribute.
     * 
     * @return the conditionRuleName value
     */
    public String getConditionRuleName()
    {
        return conditionRuleName;
    }

    /**
     * Inspector for the 'declaringMethod' attribute.
     * 
     * @return the declaringMethod value
     */
    public Method getDeclaringMethod()
    {
        return declaringMethod;
    }

    /**
     * Inspector for the 'methodToImplementation' attribute.
     * 
     * @return the methodToImplementation value
     */
    public Method getMethodToImplementation()
    {
        return methodToImplementation;
    }

    /**
     * Inspector for the 'parameters' attribute.
     * 
     * @return the parameters value
     */
    public List<String> getParameters()
    {
        return parameters;
    }

    /**
     * Inspector for the 'isBooleanResult' attribute.
     * 
     * @return the isBooleanResult value
     */
    public boolean isBooleanResult()
    {
        return isBooleanResult;
    }

    /**
     * Modifier for the 'isBooleanResult' attribute.
     * 
     * @param isBooleanResult
     *            the new isBooleanResult value to set
     */
    public void setBooleanResult(boolean isBooleanResult)
    {
        this.isBooleanResult = isBooleanResult;
    }

    /**
     * Modifier for the 'conditionRuleName' attribute.
     * 
     * @param conditionRuleName
     *            the new conditionRuleName value to set
     */
    public void setConditionRuleName(String conditionRuleName)
    {
        this.conditionRuleName = conditionRuleName;
    }

    /**
     * Modifier for the 'declaringMethod' attribute.
     * 
     * @param declaringMethod
     *            the new declaringMethod value to set
     */
    public void setDeclaringMethod(Method declaringMethod)
    {
        this.declaringMethod = declaringMethod;
    }

    /**
     * Modifier for the 'methodToImplementation' attribute.
     * 
     * @param methodToImplementation
     *            the new methodToImplementation value to set
     */
    public void setMethodToImplementation(Method methodToImplementation)
    {
        this.methodToImplementation = methodToImplementation;
    }

    /**
     * Modifier for the 'parameters' attribute.
     * 
     * @param parameters
     *            the new parameters value to set
     */
    public void setParameters(List<String> parameters)
    {
        this.parameters = parameters;
    }

}
