/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.objects.flow;

import pt.digitalis.dif.rules.annotations.Flow;
import pt.digitalis.dif.rules.objects.AbstractContribution;

/**
 * Template class for {@link Flow} classes. All Flow declarations must extend this class.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/29
 */
public abstract class AbstractFlow extends AbstractContribution {

    /**
     * Utility function to speed up CodeGen process
     * 
     * @param result
     * @param value
     * @param exception
     * @param <T>
     *            result type
     * @return a new {@link FlowActionResult} instance
     */
    protected <T> FlowActionResult<T> newFlowActionResult(FlowActionResults result, T value, Exception exception)
    {
        return new FlowActionResult<T>(result, value, exception);
    }

    /**
     * Utility function to speed up CodeGen process
     * 
     * @param value
     * @param exception
     * @param <T>
     *            result type
     * @return a new {@link FlowActionResult} instance
     */
    protected <T> FlowActionResult<T> newFlowActionResultConditionFailed(T value, Exception exception)
    {
        return new FlowActionResult<T>(FlowActionResults.CONDITION_FAILED, value, exception);
    }
}
