/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.objects.flow;

import java.lang.reflect.Method;

import pt.digitalis.dif.dem.annotations.AnnotationTags;
import pt.digitalis.dif.rules.IFlowManager;
import pt.digitalis.dif.rules.objects.AbstractMethodDescriptor;

/**
 * Defines a Flow Action
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/27
 */
public class FlowActionDescriptor extends AbstractMethodDescriptor {

    /** the flow name */
    private String flowID;

    /** the {@link IFlowManager} container */
    private IFlowManager flowManager;

    /**
     * @param flowManager
     * @param name
     * @param description
     * @param flowID
     * @param method
     * @param declaringMethod
     */
    public FlowActionDescriptor(IFlowManager flowManager, String name, String description, String flowID,
            Method method, Method declaringMethod)
    {
        if (AnnotationTags.GENERATE_ID.equals(name))
            name = method.getName();

        setDescription(description);
        setName(name);
        setMethodToImplementation(method);
        setDeclaringMethod(declaringMethod);

        // FlowActions are not allowed results different than extensions of FlowResult
        setBooleanResult(false);

        this.flowID = flowID;
        this.flowManager = flowManager;
    }

    /**
     * @param flowManager
     * @param name
     * @param description
     * @param flowID
     * @param method
     * @param declaringMethod
     * @param conditionRuleName
     */
    public FlowActionDescriptor(IFlowManager flowManager, String name, String description, String flowID,
            Method method, Method declaringMethod, String conditionRuleName)
    {
        this(flowManager, name, description, flowID, method, declaringMethod);

        if (!AnnotationTags.NONE.equals(conditionRuleName))
        {
            boolean not = conditionRuleName.startsWith("!");
            String condition = conditionRuleName.toLowerCase().replace("!", "");

            if (!condition.contains("."))
            {
                condition = flowID + "." + condition;
            }
            setConditionRuleName((not ? "!" : "") + condition);
        }
        this.flowManager = flowManager;
    }

    /**
     * @return the Flow that declares the given Action
     */
    public FlowDescriptor getFlow()
    {
        return flowManager.getFlow(getFlowID());
    }

    /**
     * Inspector for the 'flowID' attribute.
     * 
     * @return the flowID value
     */
    public String getFlowID()
    {
        return flowID;
    }

    /**
     * @return the unique flow action name
     */
    public String getUniqueName()
    {
        return flowID + "." + getName();
    }

    /**
     * Modifier for the 'flowID' attribute.
     * 
     * @param flowID
     *            the new flowID value to set
     */
    public void setFlowID(String flowID)
    {
        this.flowID = flowID;
    }
}
