/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.objects.flow;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @param <T>
 *            value type
 * @created 2010/06/30
 */
public class FlowActionResult<T> {

    /** Contains the raised exception in case of errors */
    private Exception exception;

    /** T if the flow action was successfully executed or the evaluation was T */
    private FlowActionResults result;

    /** the flow action execution value. Null for evaluation rules */
    private T value;

    /**
     * @param exception
     */
    public FlowActionResult(Exception exception)
    {
        this(FlowActionResults.FAILED, null, exception);
    }

    /**
     * @param result
     */
    public FlowActionResult(FlowActionResults result)
    {
        this(result, null, null);
    }

    /**
     * @param result
     * @param value
     */
    public FlowActionResult(FlowActionResults result, T value)
    {
        this(result, value, null);
    }

    /**
     * @param result
     * @param value
     * @param exception
     */
    public FlowActionResult(FlowActionResults result, T value, Exception exception)
    {
        this.result = result;
        this.value = value;
        this.exception = exception;
    }

    /**
     * Inspector for the 'exception' attribute.
     * 
     * @return the exception value
     */
    public Exception getException()
    {
        return exception;
    }

    /**
     * Inspector for the 'result' attribute.
     * 
     * @return the result value
     */
    public FlowActionResults getResult()
    {
        return result;
    }

    /**
     * Inspector for the 'value' attribute.
     * 
     * @return the value value
     */
    public T getValue()
    {
        return value;
    }

    /**
     * Modifier for the 'exception' attribute.
     * 
     * @param exception
     *            the new exception value to set
     */
    public void setException(Exception exception)
    {
        this.exception = exception;
    }

    /**
     * Modifier for the 'result' attribute.
     * 
     * @param result
     *            the new result value to set
     */
    public void setResult(FlowActionResults result)
    {
        this.result = result;
    }

    /**
     * Modifier for the 'value' attribute.
     * 
     * @param value
     *            the new value value to set
     */
    public void setValue(T value)
    {
        this.value = value;
    }
}
