/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.objects.rules;

import pt.digitalis.dif.rules.annotations.RuleGroup;
import pt.digitalis.dif.rules.objects.AbstractContribution;

/**
 * Template class for {@link RuleGroup} classes. All RuleGroup declarations must extend this class.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/29
 */
public abstract class AbstractRuleGroup extends AbstractContribution {

    /**
     * Utility function to speed up CodeGen process
     * 
     * @param success
     * @param result
     * @param <T>
     *            result type
     * @return a new {@link RuleResult} instance
     */
    protected <T> RuleResult<T> newRuleResult(boolean success, T result)
    {
        return new RuleResult<T>(success, result);
    }

    /**
     * Utility function to speed up CodeGen process
     * 
     * @param exception
     * @param <T>
     *            result type
     * @return a new {@link RuleResult} instance
     */
    protected <T> RuleResult<T> newRuleResult(Exception exception)
    {
        return new RuleResult<T>(exception);
    }
}
