/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.objects.rules;

import java.lang.reflect.Method;

import pt.digitalis.dif.dem.annotations.AnnotationTags;
import pt.digitalis.dif.rules.IRulesManager;
import pt.digitalis.dif.rules.objects.AbstractMethodDescriptor;

/**
 * Defines a Rule
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/21
 */
public class RuleDescriptor extends AbstractMethodDescriptor {

    /** the rules's Rule Group unique name */
    private String ruleGroupID;

    /** the {@link IRulesManager} container */
    private IRulesManager ruleManager;

    /**  */
    private RuleType type;

    /**
     * @param rulesManager
     * @param type
     * @param name
     * @param description
     * @param ruleGroupID
     * @param method
     * @param declaringMethod
     */
    public RuleDescriptor(IRulesManager rulesManager, RuleType type, String name, String description,
            String ruleGroupID, Method method, Method declaringMethod)
    {
        if (AnnotationTags.GENERATE_ID.equals(name))
            name = method.getName();

        setDescription(description);
        setName(name);
        setMethodToImplementation(method);
        setDeclaringMethod(declaringMethod);

        // Only EVALUATION are not allowed (and obligated to have) boolean result. All other must extend RuleResult
        setBooleanResult(type == RuleType.EVALUATION);

        this.ruleGroupID = ruleGroupID;
        this.type = type;
        this.ruleManager = rulesManager;
    }

    /**
     * @param rulesManager
     * @param type
     * @param name
     * @param description
     * @param ruleGroupID
     * @param method
     * @param declaringMethod
     * @param conditionRuleName
     */
    public RuleDescriptor(IRulesManager rulesManager, RuleType type, String name, String description,
            String ruleGroupID, Method method, Method declaringMethod, String conditionRuleName)
    {
        this(rulesManager, type, name, description, ruleGroupID, method, declaringMethod);

        if (!AnnotationTags.NONE.equals(conditionRuleName))
        {
            boolean not = conditionRuleName.startsWith("!");
            String condition = conditionRuleName.toLowerCase().replace("!", "");

            if (!condition.contains("."))
            {
                condition = ruleGroupID + "." + condition;
            }
            setConditionRuleName((not ? "!" : "") + condition);
        }

        this.ruleManager = rulesManager;
    }

    /**
     * @return the Rule Group that declares the given Rule
     */
    public RuleGroupDescriptor getRuleGroup()
    {
        return ruleManager.getRuleGroup(getRuleGroupID());
    }

    /**
     * Inspector for the 'ruleGroupID' attribute.
     * 
     * @return the ruleGroupID value
     */
    public String getRuleGroupID()
    {
        return ruleGroupID;
    }

    /**
     * Inspector for the 'type' attribute.
     * 
     * @return the type value
     */
    public RuleType getType()
    {
        return type;
    }

    /**
     * @return the unique rule name
     */
    public String getUniqueName()
    {
        return ruleGroupID + "." + getName();
    }

    /**
     * @return T id the current rule is of type Evaluation
     */
    public boolean isEvaluation()
    {
        return getType().equals(RuleType.EVALUATION);
    }

    /**
     * Modifier for the 'ruleGroupID' attribute.
     * 
     * @param ruleGroupID
     *            the new ruleGroupID value to set
     */
    public void setRuleGroupID(String ruleGroupID)
    {
        this.ruleGroupID = ruleGroupID;
    }

    /**
     * Modifier for the 'type' attribute.
     * 
     * @param type
     *            the new type value to set
     */
    public void setType(RuleType type)
    {
        this.type = type;
    }
}
