/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.condegen;

import java.util.Map;

import pt.digitalis.dif.rules.exceptions.MissingContextException;

/**
 * Defines an initializer for context class instances
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/27
 */
public interface IContextParameters {

    /**
     * Initializes all context parameters
     * 
     * @param params
     *            the parameter array
     * @throws MissingContextException
     *             if not all parameters have been passed or it they are not of the right types
     */
    public void initializeContext(Map<String, Object> params) throws MissingContextException;
}
