/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.exceptions;

import pt.digitalis.dif.rules.IRulesManager;
import pt.digitalis.dif.rules.annotations.RuleGroup;
import pt.digitalis.dif.rules.objects.AbstractClassDescriptor;

/**
 * An exception thrown by the {@link IRulesManager} in response to a non-managed ruleGroup initialization exception
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/06/30
 */
public class TooManyContextParamsException extends InitializationException {

    /**  */
    private static final long serialVersionUID = 1L;

    /** Too many context parameters in {@link RuleGroup} initialization */
    static private final String TOO_MANY_CONTEXT_PARAMETERS = "Too many context parameters received";

    /**
     * @param descriptor
     */
    public TooManyContextParamsException(AbstractClassDescriptor descriptor)
    {
        super(descriptor, TOO_MANY_CONTEXT_PARAMETERS);
    }

    /**
     * @param descriptor
     *            the rule group name
     */
    public TooManyContextParamsException(String descriptor)
    {
        super(null, descriptor + ": " + TOO_MANY_CONTEXT_PARAMETERS);
    }
}
