/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.exceptions.flow;

import pt.digitalis.dif.rules.IFlowManager;
import pt.digitalis.dif.rules.objects.flow.FlowActionDescriptor;

/**
 * An exception thrown by the {@link IFlowManager} in response to a non-managed flow action inner exception
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/06/30
 */
public class FlowActionException extends Exception {

    /**  */
    private static final long serialVersionUID = 1L;

    /** the Flow Action that has failed */
    private FlowActionDescriptor flowAction;

    /**
     * @param flowAction
     * @param reason
     */
    public FlowActionException(FlowActionDescriptor flowAction, String reason)
    {
        super(reason);
        this.flowAction = flowAction;
    }

    /**
     * @param flowAction
     * @param reason
     * @param exception
     */
    public FlowActionException(FlowActionDescriptor flowAction, String reason, Throwable exception)
    {
        super(reason, exception);
        this.flowAction = flowAction;
    }

    /**
     * @param flowAction
     * @param exception
     */
    public FlowActionException(FlowActionDescriptor flowAction, Throwable exception)
    {
        super(exception);
        this.flowAction = flowAction;
    }

    /**
     * Inspector for the 'flowAction' attribute.
     * 
     * @return the flowAction value
     */
    public FlowActionDescriptor getFlowAction()
    {
        return flowAction;
    }

}
