/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.exceptions.flow;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/27
 */
public class InvalidFlow extends FlowException {

    /**  */
    private static final long serialVersionUID = 1L;
    /** the given class that was classified as invalid for Flow by the manager */
    private Class<?> invalidClass;

    /**
     * @param invalidGroupClass
     */
    public InvalidFlow(Class<?> invalidGroupClass)
    {
        this(invalidGroupClass, null);
    }

    /**
     * @param invalidClass
     * @param exception
     */
    public InvalidFlow(Class<?> invalidClass, Throwable exception)
    {
        super(exception);
        this.invalidClass = invalidClass;
    }

    /**
     * Inspector for the 'invalidClass' attribute.
     * 
     * @return the invalidClass value
     */
    public Class<?> getInvalidClass()
    {
        return invalidClass;
    }
}
