/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.exceptions.rules;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/26
 */
public class InvalidRuleGroup extends RuleGroupException {

    /**  */
    private static final long serialVersionUID = 1L;
    /** the given class that was classified as invalid for RuleGroup by the manager */
    private Class<?> invalidGroupClass;

    /**
     * @param invalidGroupClass
     */
    public InvalidRuleGroup(Class<?> invalidGroupClass)
    {
        this(invalidGroupClass, null);
    }

    /**
     * @param invalidGroupClass
     * @param exception
     */
    public InvalidRuleGroup(Class<?> invalidGroupClass, Throwable exception)
    {
        super(exception);
        this.invalidGroupClass = invalidGroupClass;
    }

    /**
     * Inspector for the 'invalidGroupClass' attribute.
     * 
     * @return the invalidGroupClass value
     */
    public Class<?> getInvalidGroupClass()
    {
        return invalidGroupClass;
    }
}
