/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.objects;

/**
 * Base class for all descriptors
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/29
 */
public abstract class AbstractDescriptor {

    /**
     * The description of the rule. Must contain a simple but complete textual description of what it validates and/or
     * executes
     */
    private String description;

    /** The name of the rule id. unique inside the current group. */
    private String name;

    /**
     * Inspector for the 'description' attribute.
     * 
     * @return the description value
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Inspector for the 'name' attribute.
     * 
     * @return the name value
     */
    public String getName()
    {
        return name;
    }

    /**
     * Modifier for the 'description' attribute.
     * 
     * @param description
     *            the new description value to set
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * Modifier for the 'name' attribute.
     * 
     * @param name
     *            the new name value to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

}
