/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.objects.rules;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @param <T>
 *            result type
 * @created 2010/06/30
 */
public class RuleResult<T> {

    /** Contains the raised exception in case of errors */
    private Exception exception;

    /** the rule execution result. Null for evaluation rules */
    private T result;

    /** T if the rule was successfully executed or the evaluation was T */
    private boolean success;

    /**
     * @param success
     */
    public RuleResult(boolean success)
    {
        this(success, null, null);
    }

    /**
     * @param result
     * @param success
     */
    public RuleResult(boolean success, T result)
    {
        this(success, result, null);
    }

    /**
     * @param success
     * @param result
     * @param exception
     */
    public RuleResult(boolean success, T result, Exception exception)
    {
        this.success = success;
        this.result = result;
        this.exception = exception;
    }

    /**
     * @param exception
     */
    public RuleResult(Exception exception)
    {
        this(false, null, exception);
    }

    /**
     * Inspector for the 'exception' attribute.
     * 
     * @return the exception value
     */
    public Exception getException()
    {
        return exception;
    }

    /**
     * Inspector for the 'result' attribute.
     * 
     * @return the result value
     */
    public T getResult()
    {
        return result;
    }

    /**
     * Inspector for the 'success' attribute.
     * 
     * @return the success value
     */
    public boolean isSuccess()
    {
        return success;
    }

    /**
     * Modifier for the 'exception' attribute.
     * 
     * @param exception
     *            the new exception value to set
     */
    public void setException(Exception exception)
    {
        this.exception = exception;
    }

    /**
     * Modifier for the 'result' attribute.
     * 
     * @param result
     *            the new result value to set
     */
    public void setResult(T result)
    {
        this.result = result;
    }

    /**
     * Modifier for the 'success' attribute.
     * 
     * @param success
     *            the new success value to set
     */
    public void setSuccess(boolean success)
    {
        this.success = success;
    }
}
