/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules;

import java.util.Map;

import pt.digitalis.dif.rules.annotations.FlowAction;
import pt.digitalis.dif.rules.exceptions.flow.FlowActionException;
import pt.digitalis.dif.rules.objects.flow.AbstractFlow;
import pt.digitalis.dif.rules.objects.flow.FlowActionResult;

/**
 * Declares the private management functionalities for the Flow Manager
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/27
 */
public interface IPrivateFlowManager extends IFlowManager {

    /**
     * Runs a {@link FlowAction} and wraps the result in a {@link FlowActionResult} object. If any exception occurs in
     * the action execution it will be saved and set in the exception attribute of the {@link FlowActionResult} object.
     * 
     * @param flowInstance
     *            the flow instance
     * @param uniqueActionID
     *            the unique action to execute including the flow ID. Ex. (registrationFlow.register)
     * @return the flow action evaluation result
     * @throws FlowActionException
     */
    public FlowActionResult<?> flowExecute(AbstractFlow flowInstance, String uniqueActionID) throws FlowActionException;

    /**
     * Runs a {@link FlowAction} and wraps the result in a {@link FlowActionResult} object. If any exception occurs in
     * the action execution it will be saved and set in the exception attribute of the {@link FlowActionResult} object.
     * 
     * @param flowInstance
     *            the flow instance
     * @param uniqueActionID
     *            the unique action to execute including the flow ID. Ex. (registrationFlow.register)
     * @param parameters
     *            the action parameter map
     * @return the flow action evaluation result
     * @throws FlowActionException
     */
    public FlowActionResult<?> flowExecute(AbstractFlow flowInstance, String uniqueActionID,
            Map<String, Object> parameters) throws FlowActionException;

    /**
     * Runs a {@link FlowAction} and wraps the result in a {@link FlowActionResult} object. If any exception occurs in
     * the action execution it will be saved and set in the exception attribute of the {@link FlowActionResult} object.
     * 
     * @param flowInstance
     *            the flow instance
     * @param flowID
     *            the flow ID
     * @param actionID
     *            the action to execute
     * @return the flow action result
     * @throws FlowActionException
     */
    public FlowActionResult<?> flowExecute(AbstractFlow flowInstance, String flowID, String actionID)
            throws FlowActionException;

    /**
     * Runs a {@link FlowAction} and wraps the result in a {@link FlowActionResult} object. If any exception occurs in
     * the action execution it will be saved and set in the exception attribute of the {@link FlowActionResult} object.
     * 
     * @param flowInstance
     *            the flow instance
     * @param flowID
     *            the flow ID
     * @param actionID
     *            the action to execute
     * @param parameters
     *            the action parameter map
     * @return the flow action evaluation result
     * @throws FlowActionException
     */
    public FlowActionResult<?> flowExecute(AbstractFlow flowInstance, String flowID, String actionID,
            Map<String, Object> parameters) throws FlowActionException;

}
