/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.condegen;

import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.ConditionRuleInvalidException;
import pt.digitalis.dif.rules.exceptions.rules.RuleDoesNotExistException;
import pt.digitalis.dif.rules.exceptions.rules.RuleException;
import pt.digitalis.dif.rules.objects.AbstractClassDescriptor;
import pt.digitalis.dif.rules.objects.rules.RuleDescriptor;

/**
 * Utility class for exception throwing. this class exists for for ByteCode enhanced classes to throw exceptions since
 * direct compilation of throw statements is slow.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/22
 */
public class RuleExceptionThrower {

    /** the singleton instance */
    static private RuleExceptionThrower instance = null;

    /**
     * @return the singleton instance
     */
    static public RuleExceptionThrower getInstance()
    {
        if (instance == null)
            instance = new RuleExceptionThrower();

        return instance;
    }

    /**
     * Launches a Rule Exception
     * 
     * @param rule
     *            the rule that caused the exception
     * @return FlowActionException
     */
    public RuleException getConditionRuleInvalid(RuleDescriptor rule)
    {
        return new ConditionRuleInvalidException(rule);
    }

    /**
     * Launches a Rule Exception
     * 
     * @param rule
     *            the rule that caused the exception
     * @param reason
     *            the exception reason
     * @return FlowActionException
     */
    public RuleException getConditionRuleInvalid(RuleDescriptor rule, String reason)
    {
        if (reason != null && !"".equals(reason))
        {
            return new ConditionRuleInvalidException(rule, reason);
        }
        else
        {
            return new ConditionRuleInvalidException(rule);
        }

    }

    /**
     * Launches a Rule Exception
     * 
     * @param rule
     *            the rule that caused the exception
     * @throws RuleException
     */
    public void throwConditionRuleInvalid(RuleDescriptor rule) throws RuleException
    {
        throw getConditionRuleInvalid(rule, null);
    }

    /**
     * Launches a missing context exception
     * 
     * @param classContextInstance
     *            the {@link AbstractClassDescriptor} that was called
     * @param param
     *            the missing context parameter name
     * @throws MissingContextException
     */
    public void throwMissingContextException(String classContextInstance, String param) throws MissingContextException
    {
        throw new MissingContextException(classContextInstance, param);
    }

    /**
     * Launches a Rule Exception
     * 
     * @param uniqueID
     *            the rule that caused the exception
     * @throws RuleException
     */
    public void throwRuleDoesNotExist(String uniqueID) throws RuleException
    {
        throw new RuleDoesNotExistException(uniqueID);
    }

    /**
     * Launches a Rule Exception
     * 
     * @param rule
     *            the rule that caused the exception
     * @param exception
     *            the raised exception
     * @throws RuleException
     */
    public void throwRuleException(RuleDescriptor rule, Exception exception) throws RuleException
    {
        throw new RuleException(rule, exception);
    }

    /**
     * Launches a Rule Exception
     * 
     * @param rule
     *            the rule that caused the exception
     * @param reason
     *            of the exception to launch
     * @throws RuleException
     */
    public void throwRuleException(RuleDescriptor rule, String reason) throws RuleException
    {
        throw new RuleException(rule, reason);
    }

}
