/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.exceptions.rules;

import pt.digitalis.dif.rules.objects.rules.RuleDescriptor;

/**
 * Indicates that the condition rule of a given action was not valid
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/22
 */
public class ConditionRuleInvalidException extends RuleException {

    /** condition rule invalid error message */
    static private final String INVALID_CONDITION_RULE = "The condition rule was invalid";

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     * 
     * @param rule
     */
    public ConditionRuleInvalidException(RuleDescriptor rule)
    {
        super(rule, rule.getName() + ": " + INVALID_CONDITION_RULE);
    }

    /**
     * Default constructor
     * 
     * @param rule
     *            the rule that cause the exception
     * @param reason
     *            the exception reason
     */
    public ConditionRuleInvalidException(RuleDescriptor rule, String reason)
    {
        super(rule, rule.getName() + ": " + INVALID_CONDITION_RULE + " [" + reason + "]");
    }
}
