/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.rules.ioc;

import pt.digitalis.dif.dem.interfaces.IDIFAPI;
import pt.digitalis.dif.rules.DIFRulesAPI;
import pt.digitalis.dif.rules.FlowManager;
import pt.digitalis.dif.rules.IFlowManager;
import pt.digitalis.dif.rules.IRulesManager;
import pt.digitalis.dif.rules.RulesManager;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Declares the default DIF Rules Manager
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/21
 */
public class RulesModule implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        binder.bind(IRulesManager.class, RulesManager.class).asSingleton();
        binder.bind(IFlowManager.class, FlowManager.class).asSingleton();

        binder.bind(IDIFAPI.class, DIFRulesAPI.class).asSingleton();
    }
}
