/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.objects;

import java.util.ArrayList;
import java.util.List;

/**
 * Base class for flow/rule class declaration descriptors. For context binded fields handling
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/07/29
 */
public abstract class AbstractClassDescriptor extends AbstractDescriptor {

    /** the Rule Group definition class */
    private Class<?> clazz;

    /** The context parameter IDs of the group */
    private List<String> contextParameters = new ArrayList<String>();

    /**
     * @return the child instance names
     */
    abstract public List<String> getChildIDs();

    /**
     * @return the child instances
     */
    abstract public List<? extends AbstractMethodDescriptor> getChilds();

    /**
     * Inspector for the 'clazz' attribute.
     * 
     * @return the clazz value
     */
    public Class<?> getClazz()
    {
        return clazz;
    }

    /**
     * Inspector for the 'contextParameters' attribute.
     * 
     * @return the contextParameters value
     */
    public List<String> getContextParameters()
    {
        return contextParameters;
    }

    /**
     * @return the class that the class descriptor instances must all extend
     */
    public abstract Class<? extends AbstractContribution> getInstanceBaseImplementationClass();

    /**
     * Modifier for the 'clazz' attribute.
     * 
     * @param clazz
     *            the new clazz value to set
     */
    public void setClazz(Class<?> clazz)
    {
        this.clazz = clazz;
    }

    /**
     * Modifier for the 'contextParameters' attribute.
     * 
     * @param contextParameters
     *            the new contextParameters value to set
     */
    public void setContextParameters(List<String> contextParameters)
    {
        this.contextParameters = contextParameters;
    }

}
