/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.rules.registration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import pt.digitalis.dif.dem.annotations.AnnotationTags;
import pt.digitalis.dif.rules.annotations.Flow;
import pt.digitalis.dif.rules.annotations.RuleGroup;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/06/30
 */
public class ClassesRegistry {

    /** Classes list */
    private final Map<String, Class<?>> classesByName = new CaseInsensitiveHashMap<Class<?>>();

    /**
     * Adds a class to the registry
     * 
     * @param clazz
     *            the class to add
     */
    public void addClass(Class<?> clazz)
    {
        RuleGroup ruleGroupAnnotation = clazz.getAnnotation(RuleGroup.class);
        if (ruleGroupAnnotation == null)
        {
            Flow flowAnnotation = clazz.getAnnotation(Flow.class);
            if (flowAnnotation != null)
            {
                String name = flowAnnotation.name();
                if (AnnotationTags.GENERATE_ID.equals(name))
                {
                    name = clazz.getSimpleName().toLowerCase();
                }

                classesByName.put(name, clazz);
            }
        }
        else
        {
            String name = ruleGroupAnnotation.name();
            if (AnnotationTags.GENERATE_ID.equals(name))
            {
                name = clazz.getSimpleName().toLowerCase();
            }
            classesByName.put(name, clazz);
        }
    }

    /**
     * Inspector for the 'classList' attribute.
     * 
     * @return the classList value
     */
    public List<Class<?>> getClasses()
    {
        return new ArrayList<Class<?>>(classesByName.values());
    }

    /**
     * Inspector for the 'classesByName' attribute.
     * 
     * @return the classesByName value
     */
    public Map<String, Class<?>> getClassesByName()
    {
        return classesByName;
    }
}
