/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.test.impl;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pt.digitalis.dif.controller.http.HTTPConstants;
import pt.digitalis.dif.controller.interfaces.IChAL;
import pt.digitalis.dif.controller.interfaces.IDIFRequest;
import pt.digitalis.dif.controller.interfaces.IDIFResponse;
import pt.digitalis.dif.controller.objects.DIFRequest;
import pt.digitalis.dif.controller.objects.DIFResponse;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.startup.DIFInitializer;
import pt.digitalis.dif.test.IStageTester;
import pt.digitalis.dif.test.objects.StageCall;
import pt.digitalis.web.ancillaries.WebAncillaries;

import com.meterware.httpunit.WebResponse;

/**
 * Implementation for the IStageTester.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2008/01/24
 */
public class StageTesterImpl implements IStageTester {

    /**
     * @see pt.digitalis.dif.test.IStageTester#testStageOnServer(pt.digitalis.dif.test.objects.StageCall)
     */
    public WebResponse testStageOnServer(StageCall stage) throws Exception
    {
        return (new PageTesterImpl()).testPageGET(stage);
    }

    /**
     * @see pt.digitalis.dif.test.IStageTester#testStageStandAlone(java.lang.String, java.util.Map)
     */
    public ViewObject testStageStandAlone(String stageID, Map<String, String> parameterMap)
            throws BusinessFlowException, ControllerException
    {

        // Process annotations and build DEM
        DIFInitializer.initialize(true, false);

        // Build a request
        IDIFRequest request = new DIFRequest();
        request.setStage(stageID);

        if (parameterMap != null)
        {

            for (String parameterName: parameterMap.keySet())
            {
                request.addParameter(parameterName, (Object) parameterMap.get(parameterName));
            }
        }
        else
            parameterMap = new HashMap<String, String>();

        // Get the appropriate ChAL
        @SuppressWarnings("unchecked")
        IChAL<HttpServletRequest, HttpServletResponse> chal = DIFIoCRegistry.getRegistry().getImplementation(
                IChAL.class, "http");

        // Set parameters
        parameterMap.put(HTTPConstants.STAGE_PARAMETER, stageID); // Overwrites previous stage if it was set!!
        parameterMap.put(HTTPConstants.COMPONENT_MODE_PARAMETER, WebAncillaries.FALSE);

        // Set attributes
        Map<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(HTTPConstants.RESPONSE_ATTRIBUTE, new DIFResponse());

        HttpServletRequest httpRequest = WebAncillaries.createHttpServletRequestMock(parameterMap, attributes);
        HttpServletResponse httpResponse = WebAncillaries.createHttpServletResponseMock();

        // Execute request and store result on an object
        IDIFResponse response = chal.serve(httpRequest, httpResponse, null);

        // Return the view
        return response.getView();
    }
}
