/** 2007, Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */

package pt.digitalis.dif.test.objects;

import com.meterware.httpunit.WebResponse;

/**
 * Holds information about the response including the request execution time and the web response.
 * Implements comparable to enable element sorting when a list of responses is used.
 * Comparison is done with lexicographical comparison on the callerID.
 * 
 * @author Rodrigo Goncalves <a
 *         href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/01/30
 */
final public class ResponseData implements Comparable<ResponseData> {
    
    /** The service start time. */
    private long startTime;
    
    /** The service end time. */
    private long endTime;
    
    /** The returned web response. */
    private WebResponse response;
    
    /** The caller id. */
    private String callerID;

    /**
     * Inspector for the start time.
     * 
     * @return the start time
     */
    public long getStartTime() {
        return this.startTime;
    }

    /**
     * Modifier for the start time.
     * 
     * @param startTime the start time to set
     */
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    /**
     * Inspector for the end time.
     * 
     * @return the end time
     */
    public long getEndTime() {
        return this.endTime;
    }

    /**
     * Modifier for the end time.
     * 
     * @param endTime the end time to set
     */
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    /**
     * Inspector for the response.
     * 
     * @return the response
     */
    public WebResponse getResponse() {
        return this.response;
    }

    /**
     * Modifier for the response.
     * 
     * @param response the response to set
     */
    public void setResponse(WebResponse response) {
        this.response = response;
    }
    
    /**
     * Returns the request execution time.
     * 
     * @return the request execution time */
    public long getExecutionTime()
    {
        return endTime - startTime;
    }

    /**
     * Inspector for the caller id. 
     * 
     * @return the callerID
     */
    public String getCallerID() {
        return this.callerID;
    }

    /**
     * Modifier for the caller id.
     * 
     * @param callerID the callerID to set
     */
    public void setCallerID(String callerID) {
        this.callerID = callerID;
    }
    
   
    /**
     * 
     * @param other the
     * @return see @see
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(ResponseData other) {
        return this.callerID.compareTo(other.getCallerID());
    }
}
