/**
 * 2007, Digitalis Informatica. All rights reserved.
 *
 * Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone:
 * (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.test.objects;

import java.util.Vector;

import pt.digitalis.dif.test.IPageTester;
import pt.digitalis.dif.test.exception.PageTestException;
import pt.digitalis.dif.test.impl.PageTesterImpl;

import com.meterware.httpunit.WebResponse;

/**
 * This class implements a test plan, that is a sequence of stage calls.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Jan 23, 2008
 */
public class TestPlan {

    /** The stage call sequence. */
    private Vector<StageCall> stageCalls;

    /**
     * Adds a new stage call to the test plan.
     *
     * @param call
     *            the stage call to add to the test plan
     *
     */
    public void addStageCall(StageCall call) {
        if (stageCalls == null)
            stageCalls = new Vector<StageCall>();

        this.stageCalls.add(call);

    }

    /**
     * Executes the test plan.
     *
     * @return the web responses of all the executed stages
     * @throws PageTestException
     *             if any of the given stages doesn't run properly.
     */
    public Vector<WebResponse> execute() throws PageTestException {
        // TODO: Must provide the use of substitution variables on parameterValues that refer to the previous stage
        // WebRespopnse object. i.e. parameter "clientName" has a value of "${response.element["clientName"].value"

        Vector<WebResponse> responses = new Vector<WebResponse>();

        IPageTester pageTester = null;

        for (StageCall stageCall: stageCalls) {
            pageTester = new PageTesterImpl();
            responses.add(pageTester.testPageGET(stageCall));
        }

        return responses;
    }

    /**
     * Returns the plan size, that is the number of stage calls on the test plan.
     *
     * @return the number of stage calls on the test plan
     */
    public int planSize() {
        return this.stageCalls.size();
    }

    /** Erases all entries from the test plan. */
    public void flush() {
        stageCalls.removeAllElements();
    }
}
