/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.test;

import java.util.Map;

import com.meterware.httpunit.WebResponse;

import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;
import pt.digitalis.dif.test.objects.StageCall;
import pt.digitalis.utils.config.ConfigurationException;

/**
 * Defines behavior for stage tests.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2008/01/23
 */
public interface IStageTester {

    /**
     * Tests a given stage running on the App. Server through the listener with a given set of parameters.
     * 
     * @param stage
     *            the stage call object
     * @return a web response
     * @throws Exception
     *             if the stage can't run
     */
    public WebResponse testStageOnServer(StageCall stage) throws Exception;

    /**
     * Tests a given stage class with a given set of parameters.
     * 
     * @param stageID
     *            the stage's id
     * @param parameterMap
     *            the parameter map
     * @return a view
     * @throws BusinessFlowException
     *             if the stage can't run
     * @throws ControllerException
     *             if an internal exception was thrown
     * @throws ConfigurationException
     */
    public ViewObject testStageStandAlone(String stageID, Map<String, String> parameterMap)
            throws BusinessFlowException, ControllerException, ConfigurationException;
}
