/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.test;

import pt.digitalis.dif.test.objects.ResponseData;
import pt.digitalis.dif.test.objects.URLCall;

import java.util.List;
import java.util.Map;

/**
 * Simulates concurrent access to a given page.
 *
 * @author Rodrigo Goncalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2008/01/22
 */
public interface IConcurrentAccessPageTester
{

    /**
     * Sets a given number of requests to access a given set of URLs. Offers the possibility to set a time interval
     * between the request. Useful for testing accesses to the same page but with different parameter values.
     *
     * @param pages a map of access id's and URLCall
     * @param delay the time delay between the requests.
     *
     * @return the map of response data of the different sessions
     */
    public Map<String, ResponseData> doConcurrentAccessToPage(Map<String, URLCall> pages, long delay);

    /**
     * Sets a given number of requests to access a given URL. Offers the possibility to set a time interval between the
     * request.
     *
     * @param page             the page object
     * @param numberOfSessions the number of parallel sessions
     * @param delay            the time delay between the requests.
     *
     * @return the list of response data of the different sessions
     */
    public List<ResponseData> doConcurrentAccessToPage(URLCall page, int numberOfSessions, long delay);
}
