/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.test;

import com.meterware.httpunit.WebResponse;
import pt.digitalis.dif.test.exception.PageTestException;
import pt.digitalis.dif.test.objects.URLCall;

/**
 * Defines the expected behavior of a page tester object.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2008/01/22
 */
public interface IPageTester
{

    /**
     * Tests a page using the GET method.
     *
     * @param page the URL call object of the page to test
     *
     * @return returns the response
     *
     * @exception PageTestException if the test could not be run due to an error
     */
    public WebResponse testPageGET(URLCall page) throws PageTestException;

    /**
     * Tests a page using the POST method.
     *
     * @param page the URL call object of the page to test
     *
     * @return returns the response
     *
     * @exception PageTestException if the test could not be run due to an error
     */
    public WebResponse testPagePOST(URLCall page) throws PageTestException;
}
