/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.test;

import com.meterware.httpunit.WebResponse;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;
import pt.digitalis.dif.test.objects.StageCall;
import pt.digitalis.utils.config.ConfigurationException;

import java.util.Map;

/**
 * Defines behavior for stage tests.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2008/01/23
 */
public interface IStageTester
{

    /**
     * Tests a given stage running on the App. Server through the listener with a given set of parameters.
     *
     * @param stage the stage call object
     *
     * @return a web response
     *
     * @exception Exception if the stage can't run
     */
    public WebResponse testStageOnServer(StageCall stage) throws Exception;

    /**
     * Tests a given stage class with a given set of parameters.
     *
     * @param stageID      the stage's id
     * @param parameterMap the parameter map
     *
     * @return a view
     *
     * @exception BusinessFlowException  if the stage can't run
     * @exception ControllerException    if an internal exception was thrown
     * @exception ConfigurationException
     */
    public ViewObject testStageStandAlone(String stageID, Map<String, String> parameterMap)
            throws BusinessFlowException, ControllerException, ConfigurationException;
}
