/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.test.objects;

import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;

/**
 * Keeps a record of the expected values of the Tag, BodyTag and IterationTag interface methods.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/01/25
 */
public class TagMethodsReturnMap
{

    /** The expected return value for the javax.servlet.jsp.tagext.IterationTag#doAfterBody method. */
    private int doAfterBodyExpectedValue;

    /** The expected return value for the javax.servlet.jsp.tagext.Tag#doEndTag method. */
    private int doEndTagExpectedValue;

    /** The expected return value for the javax.servlet.jsp.tagext.BodyTag#doInitBody method. */
    private int doInitBodyExpectedValue;

    /** The expected return value for the javax.servlet.jsp.tagext.Tag#doStartTag method. */
    private int doStartTagExpectedValue;

    /** Default constructor. */
    public TagMethodsReturnMap()
    {
        this.doStartTagExpectedValue = Tag.EVAL_BODY_INCLUDE;
        this.doEndTagExpectedValue = Tag.EVAL_PAGE;
        this.doInitBodyExpectedValue = Tag.EVAL_BODY_INCLUDE;
        this.doAfterBodyExpectedValue = Tag.SKIP_BODY;
    }

    /**
     * Builds an instance with the passed expected method return values.
     *
     * @param doStartTagExpectedValue
     * @param doEndTagExpectedValue
     * @param doInitBodyExpectedValue
     * @param doAfterBodyExpectedValue
     *
     * @exception InvalidTagMethodReturnException if an invalid value is passed as expected method return.
     */
    public TagMethodsReturnMap(int doStartTagExpectedValue, int doEndTagExpectedValue, int doInitBodyExpectedValue,
            int doAfterBodyExpectedValue) throws InvalidTagMethodReturnException
    {

        setDoStartTagExpectedValue(doStartTagExpectedValue);
        setDoEndTagExpectedValue(doEndTagExpectedValue);
        setDoInitBodyExpectedValue(doInitBodyExpectedValue);
        setDoAfterBodyExpectedValue(doAfterBodyExpectedValue);
    }

    /**
     * Returns the defined expected value for the javax.servlet.jsp.tagext.IterationTag#doAfterBody method.
     *
     * @return the doAfterBodyExpectedValue
     */
    public int getDoAfterBodyExpectedValue()
    {
        return this.doAfterBodyExpectedValue;
    }

    /**
     * Sets the expected value for the javax.servlet.jsp.tagext.IterationTag#doAfterBody method.
     *
     * @param doAfterBodyExpectedValue the doAfterBodyExpectedValue to set
     *
     * @exception InvalidTagMethodReturnException if an improper value was passed as the method return
     */
    public void setDoAfterBodyExpectedValue(int doAfterBodyExpectedValue) throws InvalidTagMethodReturnException
    {
        if (validateDoAfterBodyExpectedValue(doAfterBodyExpectedValue))
            this.doAfterBodyExpectedValue = doAfterBodyExpectedValue;
        else
            throw new InvalidTagMethodReturnException("doAfterBody");
    }

    /**
     * Returns the defined expected value for the javax.servlet.jsp.tagext.Tag#doEndTag method.
     *
     * @return the doEndTagExpectedValue
     */
    public int getDoEndTagExpectedValue()
    {
        return this.doEndTagExpectedValue;
    }

    /**
     * Sets the defined value for the javax.servlet.jsp.tagext.Tag#doEndTag method.
     *
     * @param doEndTagExpectedValue the doEndTagExpectedValue to set
     *
     * @exception InvalidTagMethodReturnException if an improper value was passed as the method return
     */
    public void setDoEndTagExpectedValue(int doEndTagExpectedValue) throws InvalidTagMethodReturnException
    {
        if (validateDoEndTagExpectedValue(doEndTagExpectedValue))
            this.doEndTagExpectedValue = doEndTagExpectedValue;
        else
            throw new InvalidTagMethodReturnException("doEndTag");
    }

    /**
     * Returns the defined expected value for the javax.servlet.jsp.tagext.BodyTag#doInitBody method.
     *
     * @return the doInitBodyExpectedValue
     */
    public int getDoInitBodyExpectedValue()
    {
        return this.doInitBodyExpectedValue;
    }

    /**
     * Sets the expected value for the javax.servlet.jsp.tagext.BodyTag#doInitBody method.
     *
     * @param doInitBodyExpectedValue the doInitBodyExpectedValue to set
     *
     * @exception InvalidTagMethodReturnException if an improper value was passed as the method return
     */
    public void setDoInitBodyExpectedValue(int doInitBodyExpectedValue) throws InvalidTagMethodReturnException
    {
        if (validateDoInitBodyExpectedValue(doInitBodyExpectedValue))
            this.doInitBodyExpectedValue = doInitBodyExpectedValue;
        else
            throw new InvalidTagMethodReturnException("doInitBody");
    }

    /**
     * Returns the defined expected value for the javax.servlet.jsp.tagext.Tag#doStartTag method.
     *
     * @return the doStartTagExpectedValue
     */
    public int getDoStartTagExpectedValue()
    {
        return this.doStartTagExpectedValue;
    }

    /**
     * Sets the expected value for the javax.servlet.jsp.tagext.Tag#doStartTag method.
     *
     * @param doStartTagExpectedValue the doStartTagExpectedValue to set
     *
     * @exception InvalidTagMethodReturnException if an improper value was passed as the method return
     */
    public void setDoStartTagExpectedValue(int doStartTagExpectedValue) throws InvalidTagMethodReturnException
    {
        if (validateDoStartTagExpectedValue(doStartTagExpectedValue))
            this.doStartTagExpectedValue = doStartTagExpectedValue;
        else
            throw new InvalidTagMethodReturnException("doStartTag");
    }

    /**
     * Validates the passed value for the doAfterBody method.
     *
     * @param value the given value
     *
     * @return T if the value is EVAL_BODY_INCLUDE or SKIP_BODY, F otherwise
     */
    private boolean validateDoAfterBodyExpectedValue(int value)
    {
        return (value == IterationTag.EVAL_BODY_AGAIN || value == Tag.SKIP_BODY);
    }

    /**
     * Validates the passed value for the doEndTag method.
     *
     * @param value the given value
     *
     * @return T if the value is EVAL_BODY_INCLUDE or SKIP_BODY, F otherwise
     */
    private boolean validateDoEndTagExpectedValue(int value)
    {
        return (value == Tag.EVAL_PAGE || value == Tag.SKIP_PAGE);
    }

    /**
     * Validates the passed value for the doInitBody method.
     *
     * @param value the given value
     *
     * @return T if the value is EVAL_BODY_INCLUDE or SKIP_BODY, F otherwise
     */
    private boolean validateDoInitBodyExpectedValue(int value)
    {
        return (value == Tag.EVAL_BODY_INCLUDE || value == Tag.SKIP_BODY);
    }

    /**
     * Validates the passed value for the doStartTag method.
     *
     * @param value the given value
     *
     * @return T if the value is EVAL_BODY_INCLUDE or SKIP_BODY, F otherwise
     */
    private boolean validateDoStartTagExpectedValue(int value)
    {
        return (value == Tag.EVAL_BODY_INCLUDE || value == Tag.SKIP_BODY);
    }

    /** Exception thrown when an invalid return value is passed for a given method. */
    final static private class InvalidTagMethodReturnException extends Exception
    {

        /** The serial version UID. */
        private static final long serialVersionUID = -8390861440046074801L;

        /**
         * Builds a new exception. TODO: Enhance available information with the retruned value and call context
         * information if available
         *
         * @param methodName the name of the method
         */
        InvalidTagMethodReturnException(String methodName)
        {
            super("Invalid expected return for tag method: " + methodName + "!");
        }
    }

    /**
     * Exception thrown when the tag methods map is invalid (eg, has not been initialized, or null was passed to a
     * method that needs the type initialized)
     */
    final static public class InvalidTagMethodsReturnMapException extends Exception
    {

        /** The serial version UID. */
        private static final long serialVersionUID = -5961032867129607991L;

        /** Default constructor. */
        public InvalidTagMethodsReturnMapException()
        {
            super("Tag methods return map is in an invalid state! Check it was propperly initialized...");
        }
    }
}
