/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.documents.excel;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.RefPtgBase;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import pt.digitalis.utils.common.BeanInspector;
import pt.digitalis.utils.documents.excel.IExcelDirectDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelDirectDocumentImpl
implements IExcelDirectDocument {
    private Integer cellPosition = 0;
    private String name;
    private Integer rowPosition = 0;
    private Integer sheetNumber = 0;
    private Row templateRow = null;
    private Workbook workBook;

    public ExcelDirectDocumentImpl(InputStream inputStream) {
        try {
            this.workBook = this.getWorkbookInstance(inputStream, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ExcelDirectDocumentImpl(InputStream inputStream, boolean oldFormat) {
        try {
            this.workBook = this.getWorkbookInstance(inputStream, oldFormat);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ExcelDirectDocumentImpl(String path) {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            this.workBook = this.getWorkbookInstance(inputStream, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ExcelDirectDocumentImpl(String path, boolean oldFormat) {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            this.workBook = this.getWorkbookInstance(inputStream, oldFormat);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addCellValue(Integer sheetNumber, Integer rowPosition, Integer cellPosition, String value) {
        Cell cell;
        Row hssfRow = this.workBook.getSheetAt(sheetNumber.intValue()).getRow(rowPosition.intValue());
        if (hssfRow == null) {
            hssfRow = this.workBook.getSheetAt(sheetNumber.intValue()).createRow(rowPosition.intValue());
        }
        if ((cell = this.workBook.getSheetAt(sheetNumber.intValue()).getRow(rowPosition.intValue()).getCell(cellPosition.intValue())) == null) {
            cell = hssfRow.createCell((int)cellPosition.shortValue());
            if (this.getTemplateRow() != null && this.getTemplateRow().getCell((int)cellPosition.shortValue()) != null) {
                CellStyle cellStyle = this.getTemplateRow().getCell((int)cellPosition.shortValue()).getCellStyle();
                int cellType = this.getTemplateRow().getCell((int)cellPosition.shortValue()).getCellType();
                Comment comment = this.getTemplateRow().getCell((int)cellPosition.shortValue()).getCellComment();
                if (cellStyle != null) {
                    cell.setCellStyle(cellStyle);
                }
                if (comment != null) {
                    cell.setCellComment(comment);
                }
                cell.setCellType(cellType);
            }
        }
        Object richTextString = null;
        richTextString = this.workBook instanceof HSSFWorkbook ? new HSSFRichTextString(value) : new XSSFRichTextString(value);
        cell.setCellValue((RichTextString)richTextString);
    }

    @Override
    public void addData(List<?> data, LinkedHashMap<String, Integer> fieldsMap) {
        Iterator<String> keys = null;
        for (Object obj : data) {
            for (String key : fieldsMap.keySet()) {
                String value = BeanInspector.getValueAsString(obj, (String)key);
                if (value == null) continue;
                this.addCellValue(this.sheetNumber, this.rowPosition, fieldsMap.get(key), value);
            }
            ExcelDirectDocumentImpl excelDirectDocumentImpl = this;
            Integer n = excelDirectDocumentImpl.rowPosition;
            Integer n2 = excelDirectDocumentImpl.rowPosition = Integer.valueOf(excelDirectDocumentImpl.rowPosition + 1);
        }
    }

    @Override
    public void addData(List<?> data, String[] fields) {
        Integer cellPos = this.cellPosition;
        for (Object obj : data) {
            for (String field : fields) {
                String value;
                if (field != null && (value = BeanInspector.getValueAsString(obj, (String)field)) != null) {
                    this.addCellValue(this.sheetNumber, this.rowPosition, cellPos, value);
                }
                Integer n = cellPos;
                Integer n2 = cellPos = Integer.valueOf(cellPos + 1);
            }
            cellPos = this.cellPosition;
            ExcelDirectDocumentImpl excelDirectDocumentImpl = this;
            Integer n = excelDirectDocumentImpl.rowPosition;
            Integer n3 = excelDirectDocumentImpl.rowPosition = Integer.valueOf(excelDirectDocumentImpl.rowPosition + 1);
        }
    }

    @Override
    public void addData(List<?> data, String[] fields, Integer startRow, Integer startCell) {
        this.addData(data, fields, startRow, startCell);
    }

    @Override
    public void addData(List<?> data, String[] fields, Integer sheetNumber, Integer startRow, Integer startCell) {
        if (sheetNumber != null) {
            this.sheetNumber = sheetNumber;
        }
        if (startRow != null) {
            this.rowPosition = startRow;
        }
        if (startCell != null) {
            this.cellPosition = startCell;
        }
        this.addData(data, fields);
    }

    @Override
    public void addData(Map<String, String> data, Map<String, Integer> fieldsMap) {
        for (Map.Entry<String, Integer> entry : fieldsMap.entrySet()) {
            String value = data.get(entry.getKey());
            if (value == null) continue;
            this.addCellValue(this.sheetNumber, this.rowPosition, entry.getValue(), value);
        }
        ExcelDirectDocumentImpl excelDirectDocumentImpl = this;
        Integer n = excelDirectDocumentImpl.rowPosition;
        Integer n2 = excelDirectDocumentImpl.rowPosition = Integer.valueOf(excelDirectDocumentImpl.rowPosition + 1);
    }

    @Override
    public void copyBlockOfRows(int sheetNumber, int startPosition, int endPosition, int targetRowPosition) {
        int targetPosition = targetRowPosition;
        for (int rowPos = startPosition; rowPos <= endPosition; ++rowPos) {
            this.copyRow(sheetNumber, rowPos, targetPosition++);
        }
    }

    @Override
    public void copyRow(int sheetNumber, int sourceRowPosition, int destinationRowPosition) {
        int i;
        Sheet worksheet = this.getWorkBook().getSheetAt(sheetNumber);
        Row newRow = worksheet.getRow(destinationRowPosition);
        Row sourceRow = worksheet.getRow(sourceRowPosition);
        ArrayList<String> fArray = new ArrayList<String>();
        Row origRow = worksheet.getRow(sourceRowPosition);
        for (i = 0; i < origRow.getLastCellNum(); ++i) {
            if (origRow.getCell(i) != null && origRow.getCell(i).getCellType() == 2) {
                Ptg[] ptgs;
                String formula = origRow.getCell(i).getCellFormula();
                XSSFEvaluationWorkbook workbookWrapper = XSSFEvaluationWorkbook.create((XSSFWorkbook)((XSSFWorkbook)this.getWorkBook()));
                for (Ptg ptg : ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)workbookWrapper, (int)0, (int)0)) {
                    if (!(ptg instanceof RefPtgBase)) continue;
                    RefPtgBase ref = (RefPtgBase)ptg;
                    if (ref.isColRelative()) {
                        ref.setColumn(ref.getColumn() + 0);
                    }
                    if (!ref.isRowRelative()) continue;
                    ref.setRow(destinationRowPosition);
                }
                formula = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)workbookWrapper, (Ptg[])ptgs);
                fArray.add(formula);
                continue;
            }
            fArray.add(null);
        }
        if (newRow != null) {
            worksheet.shiftRows(destinationRowPosition, worksheet.getLastRowNum(), 1);
        } else {
            newRow = worksheet.createRow(destinationRowPosition);
        }
        block10: for (i = 0; i < sourceRow.getLastCellNum(); ++i) {
            Cell oldCell = sourceRow.getCell(i);
            Cell newCell = newRow.createCell(i);
            if (oldCell == null) {
                newCell = null;
                continue;
            }
            CellStyle newCellStyle = this.getWorkBook().createCellStyle();
            newCellStyle.cloneStyleFrom(oldCell.getCellStyle());
            newCell.setCellStyle(newCellStyle);
            if (oldCell.getCellComment() != null) {
                newCell.setCellComment(oldCell.getCellComment());
            }
            if (oldCell.getHyperlink() != null) {
                newCell.setHyperlink(oldCell.getHyperlink());
            }
            newCell.setCellType(oldCell.getCellType());
            switch (oldCell.getCellType()) {
                case 3: {
                    newCell.setCellValue(oldCell.getStringCellValue());
                    continue block10;
                }
                case 4: {
                    newCell.setCellValue(oldCell.getBooleanCellValue());
                    continue block10;
                }
                case 5: {
                    newCell.setCellErrorValue(oldCell.getErrorCellValue());
                    continue block10;
                }
                case 2: {
                    newCell.setCellFormula((String)fArray.get(i));
                    continue block10;
                }
                case 0: {
                    newCell.setCellValue(oldCell.getNumericCellValue());
                    continue block10;
                }
                case 1: {
                    newCell.setCellValue(oldCell.getRichStringCellValue());
                }
            }
        }
        for (i = 0; i < worksheet.getNumMergedRegions(); ++i) {
            CellRangeAddress cellRangeAddress = worksheet.getMergedRegion(i);
            if (cellRangeAddress.getFirstRow() != sourceRow.getRowNum()) continue;
            CellRangeAddress newCellRangeAddress = new CellRangeAddress(newRow.getRowNum(), newRow.getRowNum() + (cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow()), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn());
            worksheet.addMergedRegion(newCellRangeAddress);
        }
    }

    @Override
    public void deleteCell(Integer sheetNumber, Integer rowPosition, Integer cellPosition) {
        Cell cell = this.workBook.getSheetAt(sheetNumber.intValue()).getRow(rowPosition.intValue()).getCell(cellPosition.intValue());
        if (cell != null) {
            this.workBook.getSheetAt(sheetNumber.intValue()).getRow(rowPosition.intValue()).removeCell(cell);
        }
    }

    @Override
    public ByteArrayOutputStream exportAsOutputStream() {
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream();
            this.workBook.write((OutputStream)output);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    @Override
    public byte[] getBytes() {
        byte[] result;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.workBook.write((OutputStream)out);
            result = out.toByteArray();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    public Integer getCellPosition() {
        return this.cellPosition;
    }

    @Override
    public <T> List<T> getData(Class<T> theClass, String[] fields, Integer sheetNumber, Integer startRow, Integer endRow, Integer startCell) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object obj = null;
        for (int row = startRow.intValue(); row <= endRow; ++row) {
            int cellPos = startCell;
            try {
                obj = theClass.newInstance();
                for (String field : fields) {
                    Cell hssfCell = this.workBook.getSheetAt(sheetNumber.intValue()).getRow(row).getCell(cellPos++);
                    if (hssfCell == null) continue;
                    BeanInspector.setNestedAtributeValue(obj, (String)field, (Object)hssfCell.getRichStringCellValue().toString());
                }
                result.add(obj);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public List<String> getData(Integer sheetNumber, Integer startRow, Integer endRow, Integer cellNumber) {
        ArrayList<String> result = new ArrayList<String>();
        for (int row = startRow.intValue(); row <= endRow; ++row) {
            Cell hssfCell = this.workBook.getSheetAt(sheetNumber.intValue()).getRow(row).getCell(cellNumber.intValue());
            if (hssfCell == null) continue;
            result.add(hssfCell.getRichStringCellValue().toString());
        }
        return result;
    }

    @Override
    public List<String[]> getData(Integer sheetNumber, Integer startRow, Integer endRow, Integer startCell, Integer endCell) {
        Sheet sheet = this.workBook.getSheetAt(sheetNumber.intValue());
        ArrayList<String[]> result = new ArrayList<String[]>();
        int numberCells = endCell + 1 - startCell;
        if (endRow > sheet.getLastRowNum()) {
            endRow = sheet.getLastRowNum();
        }
        for (int row = startRow.intValue(); row <= endRow; ++row) {
            int cellPos = 0;
            String[] cellData = new String[numberCells];
            Row hssfRow = sheet.getRow(row);
            if (hssfRow == null) continue;
            for (int cell = startCell.intValue(); cell <= endCell; ++cell) {
                Cell hssfCell = hssfRow.getCell(cell);
                if (hssfCell != null) {
                    if (hssfCell.getCellType() == 0) {
                        cellData[cellPos++] = new Double(hssfCell.getNumericCellValue()).toString();
                        continue;
                    }
                    cellData[cellPos++] = hssfCell.getRichStringCellValue().toString();
                    continue;
                }
                ++cellPos;
            }
            result.add(cellData);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getRowPosition() {
        return this.rowPosition;
    }

    @Override
    public Integer getSheetNumber() {
        return this.sheetNumber;
    }

    public Row getTemplateRow() {
        return this.templateRow;
    }

    public Workbook getWorkBook() {
        return this.workBook;
    }

    private Workbook getWorkbookInstance(InputStream inputStream, boolean oldFormat) throws IOException {
        if (oldFormat) {
            return new HSSFWorkbook(inputStream);
        }
        return new XSSFWorkbook(inputStream);
    }

    @Override
    public void saveToFile(String fileName) throws IOException {
        FileOutputStream fout = new FileOutputStream(fileName);
        this.workBook.write((OutputStream)fout);
        fout.flush();
        fout.close();
    }

    @Override
    public void setCellPosition(Integer cellPosition) {
        this.cellPosition = cellPosition;
    }

    @Override
    public void setCellValue(Integer sheetNumber, Integer rowPosition, Integer cellPosition, String value) {
        Cell cell = this.workBook.getSheetAt(sheetNumber.intValue()).getRow(rowPosition.intValue()).getCell(cellPosition.intValue());
        if (cell == null) {
            this.addCellValue(sheetNumber, rowPosition, cellPosition, value);
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(value));
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setRowPosition(Integer rowPosition) {
        this.rowPosition = rowPosition;
    }

    @Override
    public void setSheetNumber(Integer sheetNumber) {
        this.sheetNumber = sheetNumber;
    }

    @Override
    public void setTemplateRow(Integer sheetNumber, Integer rowNumber) {
        this.templateRow = this.workBook.getSheetAt(sheetNumber.intValue()).getRow(rowNumber.intValue());
    }

    public void setTemplateRow(Row initialRow) {
        this.templateRow = initialRow;
    }
}

