/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.documents.excel;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.documents.IDocument;
import pt.digitalis.utils.documents.excel.ExcelCell;
import pt.digitalis.utils.documents.excel.ExcelRow;
import pt.digitalis.utils.documents.excel.ExcelSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelDocument
implements IDocument {
    private String name;
    List<String> sheetOrder = new ArrayList<String>();
    private final Map<String, ExcelSheet> sheets = new HashMap<String, ExcelSheet>();
    private Map<String, HSSFCellStyle> styles = new HashMap<String, HSSFCellStyle>();
    private Boolean usePlainText = false;
    private HSSFWorkbook workbook = null;

    public ExcelDocument(String name) {
        this.name = name;
    }

    public ExcelDocument addData(List<?> data) {
        this.getFirstSheet().addData(data);
        return this;
    }

    public ExcelDocument addData(List<?> data, List<String> properties) {
        this.getFirstSheet().addData(data, properties);
        return this;
    }

    public ExcelDocument addData(List<?> data, Map<String, String> properties) {
        this.getFirstSheet().addData(data, properties);
        return this;
    }

    public ExcelDocument addData(Map<?, ?> data) {
        this.getFirstSheet().addData(data);
        return this;
    }

    public ExcelDocument addObject(Object obj) {
        this.getFirstSheet().addObject(obj);
        return this;
    }

    public ExcelDocument addObject(Object obj, List<String> properties) {
        this.getFirstSheet().addObject(obj, properties);
        return this;
    }

    public ExcelDocument addObject(String title, Object obj) {
        this.getFirstSheet().addObject(title, obj);
        return this;
    }

    public ExcelSheet addSheet(String name) {
        ExcelSheet sheet = new ExcelSheet(name, this);
        this.sheets.put(name, sheet);
        this.sheetOrder.add(name);
        return sheet;
    }

    protected HSSFWorkbook buildWorkBook() {
        HSSFWorkbook workbook = new HSSFWorkbook();
        for (ExcelSheet sheet : this.getSheets()) {
            HSSFSheet hssfSheet = workbook.createSheet(sheet.getName());
            for (Map.Entry<Integer, ExcelRow> row : sheet.getRows().entrySet()) {
                HSSFRow hssfRow = hssfSheet.createRow(row.getKey() - 1);
                for (Map.Entry<Integer, ExcelCell> cell : row.getValue().getCells().entrySet()) {
                    HSSFCell hssfCell = hssfRow.createCell(new Integer(cell.getKey() - 1).intValue());
                    if (NumberUtils.isNumber((String)cell.getValue().getValue())) {
                        Number number = NumberUtils.createNumber((String)cell.getValue().getValue());
                        HSSFCellStyle cellStyle = this.getNumberStyle(workbook, cell.getValue().getValue());
                        if (cellStyle != null) {
                            hssfCell.setCellStyle(cellStyle);
                        }
                        hssfCell.setCellValue(number.doubleValue());
                        continue;
                    }
                    HSSFRichTextString value = new HSSFRichTextString(cell.getValue().getValue());
                    hssfCell.setCellValue((RichTextString)value);
                }
            }
        }
        return workbook;
    }

    @Override
    public ByteArrayOutputStream exportAsOutputStream() {
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream();
            this.getWorkbook().write((OutputStream)output);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    @Override
    public byte[] getBytes() {
        return this.getWorkbook().getBytes();
    }

    private ExcelSheet getFirstSheet() {
        if (this.sheets.isEmpty()) {
            this.addSheet("Sheet1");
        }
        return this.sheets.get(this.sheetOrder.get(0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    private HSSFCellStyle getNumberStyle(HSSFWorkbook workbookParam, String value) {
        String format = "";
        if (value.contains(".") || value.contains(",")) {
            format = value.replaceAll("[0-9]", "#");
        }
        if (StringUtils.isNotBlank((String)format)) {
            HSSFCellStyle cellStyle = this.styles.get(format);
            if (cellStyle == null) {
                cellStyle = workbookParam.createCellStyle();
                cellStyle.setDataFormat(workbookParam.getCreationHelper().createDataFormat().getFormat(format));
                this.styles.put(format, cellStyle);
            }
            return cellStyle;
        }
        return null;
    }

    public ExcelSheet getSheet(String name) {
        return this.sheets.get(name);
    }

    public List<ExcelSheet> getSheets() {
        ArrayList<ExcelSheet> results = new ArrayList<ExcelSheet>();
        for (String id : this.sheetOrder) {
            results.add(this.sheets.get(id));
        }
        return results;
    }

    public Boolean getUsePlainText() {
        return this.usePlainText;
    }

    public HSSFWorkbook getWorkbook() {
        if (this.workbook == null) {
            this.workbook = this.buildWorkBook();
        }
        return this.workbook;
    }

    @Override
    public void saveToFile(String fileName) throws IOException {
        FileOutputStream fout = new FileOutputStream(fileName);
        fout.write(this.exportAsOutputStream().toByteArray());
        fout.flush();
        fout.close();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setUsePlainText(Boolean usePlainText) {
        this.usePlainText = usePlainText;
    }
}

