/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.documents.excel;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.jsoup.Jsoup;
import pt.digitalis.utils.common.BeanInspector;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.IBeanPropertyInspector;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.documents.excel.ExcelDocument;
import pt.digitalis.utils.documents.excel.ExcelRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelSheet {
    private static final List<Class> unitaryClasses = new ArrayList<Class>(){
        private static final long serialVersionUID = 3607610035754690014L;
        {
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Boolean.class);
            this.add(Character.class);
            this.add(String.class);
            this.add(Short.class);
            this.add(Date.class);
            this.add(Double.class);
        }
    };
    private ExcelDocument excelDocument;
    Integer maxRowIndex = 0;
    private String name;
    private final Map<Integer, ExcelRow> rows = new HashMap<Integer, ExcelRow>();

    public ExcelSheet(String name) {
        this.name = name;
    }

    public ExcelSheet(String name, ExcelDocument excelDocument) {
        this.name = name;
        this.excelDocument = excelDocument;
    }

    public ExcelSheet addData(List<?> data) {
        for (Object obj : data) {
            this.addObject(obj);
        }
        return this;
    }

    public ExcelSheet addData(List<?> data, List<String> properties) {
        for (Object obj : data) {
            this.addObject(obj, properties);
        }
        return this;
    }

    public ExcelSheet addData(List<?> data, Map<String, String> properties) {
        ExcelRow row = this.addRow();
        for (String title : properties.keySet()) {
            row.addCell(title);
        }
        ArrayList<String> propertiesPath = new ArrayList<String>();
        propertiesPath.addAll(properties.values());
        this.addData(data, propertiesPath);
        return this;
    }

    public ExcelSheet addData(Map<?, ?> data) {
        for (Map.Entry<?, ?> entry : data.entrySet()) {
            this.addObject(entry.getKey().toString(), entry.getValue());
        }
        return this;
    }

    public ExcelSheet addDataFromBeans(List<IBeanAttributes> data, List<String> properties) {
        for (IBeanAttributes obj : data) {
            this.addObject(obj, properties);
        }
        return this;
    }

    public ExcelSheet addObject(IBeanAttributes bean, List<String> attrs) {
        if (!attrs.isEmpty() && bean != null) {
            ExcelRow row = this.addRow();
            for (String attrName : attrs) {
                row.addCell(bean.getAttributeAsString(attrName));
            }
        }
        return this;
    }

    public ExcelSheet addObject(Object obj) {
        Collection values = BeanInspector.getAttributeValues((Object)obj).values();
        if (!values.isEmpty()) {
            ExcelRow row = this.addRow();
            for (String value : values) {
                row.addCell(value);
            }
        }
        return this;
    }

    public ExcelSheet addObject(Object obj, List<String> properties) {
        if (obj != null && properties != null && !properties.isEmpty()) {
            ExcelRow row = this.addRow();
            for (String prop : properties) {
                String value = this.getObjectPropertyValue(obj, prop);
                if (value == null) {
                    value = this.getObjectPropertyValue(obj, prop.replaceAll("\\.", "\\_"));
                } else if (this.excelDocument.getUsePlainText().booleanValue()) {
                    String plainText = StringEscapeUtils.unescapeHtml((String)value);
                    value = Jsoup.parse((String)plainText).text();
                }
                row.addCell(value);
            }
        }
        return this;
    }

    public ExcelSheet addObject(String title, Object obj) {
        if (unitaryClasses.contains(obj.getClass())) {
            ExcelRow row = this.addRow();
            row.addCell(title);
            row.addCell(obj.toString());
        } else {
            Collection values = BeanInspector.getAttributeValues((Object)obj).values();
            if (!values.isEmpty()) {
                ExcelRow row = this.addRow();
                row.addCell(title);
                for (String value : values) {
                    row.addCell(value);
                }
            }
        }
        return this;
    }

    public ExcelRow addRow() {
        return this.addRow(this.maxRowIndex + 1);
    }

    public ExcelRow addRow(Integer index) {
        if (index > this.maxRowIndex) {
            this.maxRowIndex = index;
        }
        ExcelRow row = new ExcelRow();
        this.rows.put(index, row);
        return row;
    }

    public ExcelDocument getExcelDocument() {
        return this.excelDocument;
    }

    public String getName() {
        return this.name;
    }

    private String getObjectPropertyValue(Object obj, String propertyName) {
        IBeanPropertyInspector beanInspector;
        boolean implementsPropertyInspector = obj instanceof IBeanPropertyInspector;
        boolean isMap = obj instanceof Map;
        IBeanPropertyInspector iBeanPropertyInspector = beanInspector = implementsPropertyInspector ? (IBeanPropertyInspector)obj : null;
        if (implementsPropertyInspector) {
            if (beanInspector != null) {
                return beanInspector.getAttributeAsString(propertyName);
            }
            return null;
        }
        if (isMap) {
            return StringUtils.toStringOrNull(((Map)obj).get(propertyName));
        }
        return BeanInspector.getValueAsString((Object)obj, (String)propertyName);
    }

    public ExcelRow getRow(Integer index) {
        return this.rows.get(index);
    }

    public Map<Integer, ExcelRow> getRows() {
        return this.rows;
    }

    public void setName(String name) {
        this.name = name;
    }
}

