/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.documents.template;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import pt.digitalis.utils.config.FreeMarkerConfig;
import pt.digitalis.utils.documents.IDocument;
import pt.digitalis.utils.documents.exception.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerDocument
implements IDocument {
    private final Configuration cfg;
    private String name;
    private final Map<String, Object> properties;
    private final String templateName;

    public FreemarkerDocument(String templatePath, Map<String, Object> properties) throws IOException {
        String templateName;
        StringBuffer templateBaseDir = new StringBuffer();
        templateBaseDir.append(templatePath.substring(0, templatePath.lastIndexOf("/")));
        this.templateName = templateName = templatePath.substring(templatePath.lastIndexOf("/") + 1, templatePath.length());
        this.properties = properties;
        this.cfg = new Configuration();
        FileTemplateLoader templateLoader = new FileTemplateLoader(new File(Thread.currentThread().getContextClassLoader().getResource(templateBaseDir.toString()).getPath()));
        this.cfg.setTemplateLoader((TemplateLoader)templateLoader);
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    public FreemarkerDocument(String templateName, String template, Map<String, Object> properties) throws IOException {
        this.templateName = templateName;
        this.properties = properties;
        this.cfg = new Configuration();
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        stringLoader.putTemplate(templateName, template);
        this.cfg.setTemplateLoader((TemplateLoader)stringLoader);
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    @Override
    public ByteArrayOutputStream exportAsOutputStream() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String encoding = FreeMarkerConfig.getInstance().getEncoding();
        OutputStreamWriter out = null;
        try {
            out = encoding != null && !"".equals(encoding) ? new OutputStreamWriter((OutputStream)output, encoding) : new OutputStreamWriter(output);
            this.processTemplate(out);
            ((Writer)out).flush();
            output.close();
        }
        catch (IOException e) {
            output = null;
            e.printStackTrace();
        }
        catch (TemplateException e) {
            output = null;
            e.printStackTrace();
        }
        return output;
    }

    public String exportAsString() throws DocumentException {
        String output = null;
        StringWriter out = new StringWriter();
        try {
            this.processTemplate(out);
            ((Writer)out).flush();
            output = ((Object)out).toString();
        }
        catch (IOException e) {
            throw new DocumentException(e);
        }
        catch (TemplateException e) {
            throw new DocumentException(e);
        }
        return output;
    }

    @Override
    public byte[] getBytes() {
        return this.exportAsOutputStream().toByteArray();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void processTemplate(Writer out) throws IOException, TemplateException {
        String encoding = FreeMarkerConfig.getInstance().getEncoding();
        Template temp = null;
        temp = encoding != null && !"".equals(encoding) ? this.cfg.getTemplate(this.templateName, encoding) : this.cfg.getTemplate(this.templateName);
        temp.process(this.properties, out);
    }

    @Override
    public void saveToFile(String fileName) throws IOException {
        String encoding = FreeMarkerConfig.getInstance().getEncoding();
        BufferedWriter out = encoding != null && !"".equals(encoding) ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));
        try {
            this.processTemplate(out);
            out.flush();
            out.close();
        }
        catch (TemplateException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

