/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.reporting.impl.jasperreports;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseSubreport;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.reporting.AbstractDIFReport;
import pt.digitalis.utils.reporting.IReportDataSource;
import pt.digitalis.utils.reporting.ReportExportFormat;
import pt.digitalis.utils.reporting.exception.ReportingException;

public class ReportJasperImpl
extends AbstractDIFReport {
    private JasperPrint jasperPrint;
    private JasperReport jasperReport;

    private static synchronized JasperPrint fillReportFromConnection(JasperReport report, Connection jdbcConnection, Map<String, Object> parameters) throws JRException {
        return JasperFillManager.fillReport((JasperReport)report, parameters, (Connection)jdbcConnection);
    }

    private static synchronized JasperPrint fillReportFromDataSource(JasperReport report, JRDataSource dataSource, Map<String, Object> parameters) throws JRException {
        return JasperFillManager.fillReport((JasperReport)report, parameters, (JRDataSource)dataSource);
    }

    @Override
    public void compileReport() throws ReportingException {
        block8: {
            try {
                if (this.getJasperReport() != null) break block8;
                InputStream templateInputStream = null;
                String baseDir = null;
                if (StringUtils.isNotBlank((String)this.getTemplatePath())) {
                    baseDir = StringUtils.substringBeforeLast((String)StringUtils.substringBeforeLast((String)this.getTemplatePath(), (String)"\\"), (String)"/");
                    templateInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getTemplatePath());
                } else if (this.getTemplateInputStream() != null) {
                    templateInputStream = this.getTemplateInputStream();
                }
                if (templateInputStream == null) {
                    try {
                        templateInputStream = new FileInputStream(this.getTemplatePath());
                    }
                    catch (FileNotFoundException e) {
                        throw new JRException((Throwable)e);
                    }
                }
                this.setJasperReport(JasperCompileManager.compileReport((InputStream)templateInputStream));
                this.compileSubreports(this.getJasperReport(), baseDir);
            }
            catch (JRException exception) {
                this.setJasperReport(null);
                throw new ReportingException("The report can't be compiled from template: " + this.getTemplatePath(), exception);
            }
        }
    }

    private void compileSectionSubreports(String baseDir, List<?> list) throws JRException {
        for (Object obj : list) {
            URL jrxmlFile;
            if (!(obj instanceof JRBaseSubreport)) continue;
            String jasperPath = ((JRBaseSubreport)obj).getExpression().getText();
            jasperPath = StringUtils.removeEnd((String)jasperPath, (String)"\"");
            jasperPath = jasperPath.substring(StringUtils.lastIndexOf((String)jasperPath, (char)'\"') + 1);
            String jrxmlPath = jasperPath.replace(".jasper", ".jrxml");
            String jrxmlPathWithBaseDir = "";
            String jasperPathWithBaseDir = "";
            String jrxmlPathBaseDir = StringUtils.substringBeforeLast((String)StringUtils.substringBeforeLast((String)jrxmlPath, (String)"\\"), (String)"/");
            if (!(StringUtils.isBlank((String)baseDir) || !StringUtils.isBlank((String)jrxmlPathBaseDir) && jrxmlPathBaseDir.equals(baseDir))) {
                jrxmlPathWithBaseDir = baseDir + "/" + jrxmlPath;
                jasperPathWithBaseDir = baseDir + "/" + jasperPath;
            }
            boolean found = false;
            URL jasperFile = null;
            if (!"".equals(jasperPathWithBaseDir)) {
                jasperFile = Thread.currentThread().getContextClassLoader().getResource(jasperPathWithBaseDir);
            }
            if (jasperFile == null) {
                jrxmlFile = null;
                if (!"".equals(jrxmlPathWithBaseDir)) {
                    jrxmlFile = Thread.currentThread().getContextClassLoader().getResource(jrxmlPathWithBaseDir);
                }
                if (jrxmlFile != null) {
                    JasperCompileManager.compileReportToFile((String)jrxmlFile.getFile());
                    found = true;
                }
            } else {
                found = true;
            }
            if (!found) {
                jasperFile = Thread.currentThread().getContextClassLoader().getResource(jasperPath);
            }
            if (!found && jasperFile == null) {
                jrxmlFile = Thread.currentThread().getContextClassLoader().getResource(jrxmlPath);
                if (jrxmlFile != null) {
                    String subReportPath = JasperCompileManager.compileReportToFile((String)jrxmlFile.getFile());
                    JasperReport subReport = (JasperReport)JRLoader.loadObjectFromFile((String)subReportPath);
                    this.compileSubreports(subReport, baseDir);
                    found = true;
                }
            } else {
                found = true;
            }
            if (found) continue;
            try {
                FileOutputStream jasperStream = new FileOutputStream(!"".equals(jasperPathWithBaseDir) ? jasperPathWithBaseDir : jasperPath);
                FileInputStream jrxmlStream = new FileInputStream(!"".equals(jrxmlPathWithBaseDir) ? jrxmlPathWithBaseDir : jrxmlPath);
                JasperCompileManager.compileReportToStream((InputStream)jrxmlStream, (OutputStream)jasperStream);
            }
            catch (FileNotFoundException e) {
                throw new JRException((Throwable)e);
            }
        }
    }

    private void compileSubreports(JasperReport jr, String baseDir) throws JRException {
        if (jr != null) {
            if (jr.getGroups() != null) {
                for (JRGroup jRGroup : jr.getGroups()) {
                    if (jRGroup.getGroupHeaderSection().getBands() != null) {
                        for (JRBand band : jRGroup.getGroupHeaderSection().getBands()) {
                            this.compileSectionSubreports(baseDir, band.getChildren());
                        }
                    }
                    if (jRGroup.getGroupFooterSection().getBands() == null) continue;
                    for (JRBand band : jRGroup.getGroupFooterSection().getBands()) {
                        this.compileSectionSubreports(baseDir, band.getChildren());
                    }
                }
            }
            if (jr.getColumnHeader() != null) {
                this.compileSectionSubreports(baseDir, jr.getColumnHeader().getChildren());
            }
            if (jr.getColumnFooter() != null) {
                this.compileSectionSubreports(baseDir, jr.getColumnFooter().getChildren());
            }
            if (jr.getDetailSection() != null) {
                for (JRGroup jRGroup : jr.getDetailSection().getBands()) {
                    this.compileSectionSubreports(baseDir, jRGroup.getChildren());
                }
            }
            if (jr.getSummary() != null) {
                this.compileSectionSubreports(baseDir, jr.getSummary().getChildren());
            }
            if (jr.getBackground() != null) {
                this.compileSectionSubreports(baseDir, jr.getBackground().getChildren());
            }
            if (jr.getLastPageFooter() != null) {
                this.compileSectionSubreports(baseDir, jr.getLastPageFooter().getChildren());
            }
            if (jr.getNoData() != null) {
                this.compileSectionSubreports(baseDir, jr.getNoData().getChildren());
            }
        }
    }

    @Override
    public void exportToFile(String outputFileName) throws ReportingException {
        try {
            String outFile = outputFileName + super.getExportFormat().getFileExtension();
            if (super.getExportFormat().equals((Object)ReportExportFormat.PDF)) {
                JasperExportManager.exportReportToPdfFile((JasperPrint)this.getJasperPrint(), (String)outFile);
            } else if (super.getExportFormat().equals((Object)ReportExportFormat.XLS)) {
                JRXlsExporter exporter = new JRXlsExporter();
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getJasperPrint());
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outFile);
                exporter.exportReport();
            } else if (super.getExportFormat().equals((Object)ReportExportFormat.HTML)) {
                JRHtmlExporter exporter = new JRHtmlExporter();
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getJasperPrint());
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outFile);
                exporter.exportReport();
            } else if (super.getExportFormat().equals((Object)ReportExportFormat.XML)) {
                JasperExportManager.exportReportToXmlFile((JasperPrint)this.getJasperPrint(), (String)outFile, (boolean)true);
            }
        }
        catch (JRException exception) {
            throw new ReportingException("Could not export report to " + outputFileName + super.getExportFormat().getFileExtension(), exception);
        }
    }

    @Override
    public void exportToStream(OutputStream outputStream) throws ReportingException {
        try {
            if (super.getExportFormat().equals((Object)ReportExportFormat.PDF)) {
                JasperExportManager.exportReportToPdfStream((JasperPrint)this.getJasperPrint(), (OutputStream)outputStream);
            } else if (super.getExportFormat().equals((Object)ReportExportFormat.XML)) {
                JasperExportManager.exportReportToXmlStream((JasperPrint)this.getJasperPrint(), (OutputStream)outputStream);
            } else if (super.getExportFormat().equals((Object)ReportExportFormat.XLS)) {
                JRXlsExporter exporter = new JRXlsExporter();
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getJasperPrint());
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
                exporter.exportReport();
            } else if (super.getExportFormat().equals((Object)ReportExportFormat.HTML)) {
                JRHtmlExporter exporter = new JRHtmlExporter();
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getJasperPrint());
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
                exporter.exportReport();
            }
        }
        catch (JRException exception) {
            throw new ReportingException("Could not export report to " + outputStream.toString(), exception);
        }
    }

    @Override
    public void fillReport() throws ReportingException {
        boolean ignoreMissingFont = JRProperties.getBooleanProperty((String)"net.sf.jasperreports.awt.ignore.missing.font");
        try {
            if (this.getJasperPrint() == null) {
                if (this.getParameters() == null) {
                    this.setParameters(new HashMap<String, Object>());
                }
                JRProperties.setProperty((String)"net.sf.jasperreports.awt.ignore.missing.font", (boolean)true);
                this.setJasperPrint(JasperFillManager.fillReport((JasperReport)this.getJasperReport(), this.getParameters(), (JRDataSource)new JREmptyDataSource()));
            }
        }
        catch (JRException exception) {
            throw new ReportingException("The report can't be filled!", exception);
        }
        JRProperties.setProperty((String)"net.sf.jasperreports.awt.ignore.missing.font", (boolean)ignoreMissingFont);
    }

    @Override
    public void fillReportFromConnection(Connection jdbcConnection) throws ReportingException {
        boolean ignoreMissingFont = JRProperties.getBooleanProperty((String)"net.sf.jasperreports.awt.ignore.missing.font");
        try {
            if (this.getJasperPrint() == null) {
                if (jdbcConnection == null) {
                    throw new ReportingException("Invalid JDBC connection! Could not connect to: ");
                }
                if (this.getParameters() == null) {
                    this.setParameters(new HashMap<String, Object>());
                }
                JRProperties.setProperty((String)"net.sf.jasperreports.awt.ignore.missing.font", (boolean)true);
                this.setJasperPrint(ReportJasperImpl.fillReportFromConnection(this.getJasperReport(), jdbcConnection, this.getParameters()));
            }
        }
        catch (JRException exception) {
            throw new ReportingException("The report can't be filled!", exception);
        }
        JRProperties.setProperty((String)"net.sf.jasperreports.awt.ignore.missing.font", (boolean)ignoreMissingFont);
    }

    @Override
    public void fillReportFromDataSource(IReportDataSource dataSource) throws ReportingException {
        boolean ignoreMissingFont = JRProperties.getBooleanProperty((String)"net.sf.jasperreports.awt.ignore.missing.font");
        try {
            if (this.getJasperPrint() == null) {
                if (dataSource == null) {
                    throw new ReportingException("The report can't be filled! Data source was null...");
                }
                if (this.getParameters() == null) {
                    this.setParameters(new HashMap<String, Object>());
                }
                JRProperties.setProperty((String)"net.sf.jasperreports.awt.ignore.missing.font", (boolean)true);
                this.setJasperPrint(ReportJasperImpl.fillReportFromDataSource(this.getJasperReport(), (JRDataSource)dataSource, this.getParameters()));
            }
        }
        catch (JRException exception) {
            throw new ReportingException("The report can't be filled!", exception);
        }
        JRProperties.setProperty((String)"net.sf.jasperreports.awt.ignore.missing.font", (boolean)ignoreMissingFont);
    }

    @Override
    public void generateReport(Connection jdbcConnection, OutputStream outputStream) throws ReportingException {
        if (this.getJasperReport() == null && super.getTemplatePath() != null) {
            this.compileReport();
        }
        if (this.getJasperPrint() == null) {
            this.fillReportFromConnection(jdbcConnection);
        }
        this.exportToStream(outputStream);
    }

    @Override
    public void generateReport(Connection jdbcConnection, String outputFileName) throws ReportingException {
        if (this.getJasperReport() == null && super.getTemplatePath() != null) {
            this.compileReport();
        }
        if (this.getJasperPrint() == null) {
            this.fillReportFromConnection(jdbcConnection);
        }
        this.exportToFile(outputFileName);
    }

    @Override
    public void generateReport(IReportDataSource dataSource, OutputStream outputStream) throws ReportingException {
        if (this.getJasperReport() == null && (super.getTemplatePath() != null || super.getTemplateInputStream() != null)) {
            this.compileReport();
        }
        if (this.getJasperPrint() == null) {
            this.fillReportFromDataSource(dataSource);
        }
        this.exportToStream(outputStream);
    }

    @Override
    public void generateReport(IReportDataSource dataSource, String outputFileName) throws ReportingException {
        if (this.getJasperReport() == null && (super.getTemplatePath() != null || super.getTemplateInputStream() != null)) {
            this.compileReport();
        }
        if (this.getJasperPrint() == null) {
            this.fillReportFromDataSource(dataSource);
        }
        this.exportToFile(outputFileName);
    }

    @Override
    public void generateReport(String outputFileName) throws ReportingException {
        if (this.getJasperReport() == null && (super.getTemplatePath() != null || super.getTemplateInputStream() != null)) {
            this.compileReport();
        }
        if (this.getJasperPrint() == null) {
            this.fillReport();
        }
        this.exportToFile(outputFileName);
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public void setJasperPrint(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
    }

    public JasperReport getJasperReport() {
        return this.jasperReport;
    }

    public void setJasperReport(JasperReport jasperReport) {
        this.jasperReport = jasperReport;
    }

    public String getQuerySQL() {
        JRQuery query = this.getJasperReport().getQuery();
        StringBuffer buffer = new StringBuffer();
        block3: for (JRQueryChunk chunk : query.getChunks()) {
            switch (chunk.getType()) {
                case 2: {
                    buffer.append(this.getParameters().get(chunk.getText()));
                    continue block3;
                }
                default: {
                    buffer.append(chunk.getText());
                }
            }
        }
        return buffer.toString();
    }
}

