/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.pdf;

import com.lowagie.text.DocumentException;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;

/**
 * The Class PDFUtils.
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Jan 31, 2012
 */
public class PDFUtils
{

    /**
     * Creates the dummy pdf.
     *
     * @return the {@link ByteArrayOutputStream} PDF
     *
     * @exception DocumentException the document exception
     * @exception IOException       Signals that an I/O exception has occurred.
     */
    @Deprecated
    public static ByteArrayOutputStream createDummyPDF() throws DocumentException, IOException
    {
        return CertificateManager.createDummyPDF();
    }

    /**
     * Gets if certificate available
     *
     * @return if certificate available
     *
     * @exception Exception
     */
    @Deprecated
    public static boolean getCertificateAvailable() throws Exception
    {
        return CertificateManager.getInstance().getDefaultCertificateAvailable();
    }

    /**
     * Gets the certificate data.
     *
     * @return the certificate data
     *
     * @exception Exception
     */
    @Deprecated
    public static Map<String, String> getCertificateData() throws Exception
    {
        return CertificateManager.getInstance().getDefaultCertificateData();
    }

    /**
     * Sign PDF.
     *
     * @param pdfToSign The PDF to Sign
     *
     * @return Then PDF Signed in
     *
     * @exception Exception
     */
    @Deprecated
    public static ByteArrayOutputStream signPDF(byte[] pdfToSign) throws Exception
    {
        return CertificateManager.getInstance().signPDF(pdfToSign);
    }

    /**
     * Sign PDF.
     *
     * @param pdfToSign     The PDF to Sign
     * @param showSignature <code>false</code> to make the signature invisible
     * @param reason        the reason (signature property)
     * @param location      the location (signature property)
     * @param contact       the contact (signature property)
     * @param lowerLeftX    the lower left x
     * @param lowerLeftY    the lower left y
     * @param upperRightX   the upper right x
     * @param upperRightY   the upper right y
     *
     * @return Then PDF Signed
     *
     * @exception Exception
     */
    @Deprecated
    public static ByteArrayOutputStream signPDF(byte[] pdfToSign, boolean showSignature, String reason, String location,
            String contact, Double lowerLeftX, Double lowerLeftY, Double upperRightX, Double upperRightY)
            throws Exception
    {
        return CertificateManager.getInstance()
                .signPDF(pdfToSign, showSignature, reason, location, contact, lowerLeftX, lowerLeftY, upperRightX,
                        upperRightY);
    }

    /**
     * Validate signature.
     *
     * @param pdfToValidateSingature the pdf to validate Signature
     *
     * @return true, if successful
     *
     * @exception Exception the exception
     */
    @Deprecated
    public static boolean validateSignature(byte[] pdfToValidateSingature) throws Exception
    {
        return CertificateManager.getInstance().validateSignature(pdfToValidateSingature);
    }
}
