package pt.digitalis.utils.config;

import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;
import pt.digitalis.utils.config.annotations.ConfigVirtualPathForNode;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Jan 11, 2012
 */
@ConfigID("Digi Utils")
@ConfigSectionID("FreeMarker")
@ConfigVirtualPathForNode("dif2/FreeMarker")
public class FreeMarkerConfig
{

    /** the singleton instance */
    static private FreeMarkerConfig instance = null;

    /** The FreeMarker Document Encoding */
    private String encoding;

    /**
     * @return the singleton instance of Mail Sender
     *
     * @exception ConfigurationException
     */
    @ConfigIgnore
    static public FreeMarkerConfig getInstance() throws ConfigurationException
    {
        if (instance == null)
        {
            instance = ConfigurationsProvider.getConfigurations().readConfiguration(FreeMarkerConfig.class);
        }

        return instance;
    }

    /**
     * Inspector for the 'encoding' attribute.
     *
     * @return the encoding value
     */
    @ConfigDefault("ISO-8859-1")
    public String getEncoding()
    {
        return encoding;
    }

    /**
     * Modifier for the 'encoding' attribute.
     *
     * @param encoding the new encoding value to set
     */
    public void setEncoding(String encoding)
    {
        this.encoding = encoding;
    }
}
