package pt.digitalis.utils.documents;

import pt.digitalis.utils.documents.excel.ExcelDocument;
import pt.digitalis.utils.documents.template.FreemarkerDocument;

import java.io.IOException;
import java.util.Map;

/**
 * Office document factory
 *
 * @author Antnio Silva <a href="mailto:asilva@digitalis.pt">asilva@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/08/01
 */
public class DocumentFactory
{

    /**
     * Creates a new Excel document object
     *
     * @param name the name of the document
     *
     * @return IDocument
     */
    public static ExcelDocument getExcelDocument(String name)
    {
        return new ExcelDocument(name);
    }

    /**
     * Creates a new FreeMarker document object
     *
     * @param templatePath the template complete file path
     * @param properties
     *
     * @return IDocument the FreeMarker Document
     *
     * @exception IOException if an IOException occurrs
     */
    public static FreemarkerDocument getFreeMarkerDocument(String templatePath, Map<String, Object> properties)
            throws IOException
    {
        return new FreemarkerDocument(templatePath, properties);
    }

    /**
     * Creates a new FreeMaker document object
     *
     * @param templateName the template name
     * @param template     the template
     * @param properties   the properties rootMap
     *
     * @return the Document the FreeMarker Document
     *
     * @exception IOException if an IOException occurrs
     */
    public static FreemarkerDocument getFreeMarkerDocument(String templateName, String template,
            Map<String, Object> properties) throws IOException
    {
        return new FreemarkerDocument(templateName, template, properties);
    }
}
